/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.selfservice.example;

import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.StringUtils;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.ActionResponse;
import org.forgerock.json.resource.BadRequestException;
import org.forgerock.json.resource.InternalServerErrorException;
import org.forgerock.json.resource.NotSupportedException;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourceResponse;
import org.forgerock.json.resource.Responses;
import org.forgerock.json.resource.SingletonResourceProvider;
import org.forgerock.json.resource.UpdateRequest;
import org.forgerock.services.context.Context;
import org.forgerock.util.Reject;
import org.forgerock.util.promise.Promise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ExampleEmailService
implements SingletonResourceProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExampleEmailService.class);
    private final String host;
    private final String port;
    private final String username;
    private final String password;

    ExampleEmailService(JsonValue config) {
        this.host = config.get("host").required().asString();
        this.port = config.get("port").required().asString();
        this.username = System.getProperty("mailserver.username");
        this.password = System.getProperty("mailserver.password");
        Reject.ifNull((Object)this.username, (String)this.password);
    }

    public Promise<ActionResponse, ResourceException> actionInstance(Context context, ActionRequest request) {
        if (request.getAction().equals("send")) {
            try {
                JsonValue response = this.sendEmail(request.getContent());
                return Responses.newActionResponse((JsonValue)response).asPromise();
            }
            catch (ResourceException rE) {
                return rE.asPromise();
            }
        }
        return new NotSupportedException("Unknown action " + request.getAction()).asPromise();
    }

    private JsonValue sendEmail(JsonValue document) throws ResourceException {
        String to = document.get("to").asString();
        if (StringUtils.isEmpty((CharSequence)to)) {
            throw new BadRequestException("Field to is not specified");
        }
        String from = document.get("from").asString();
        if (StringUtils.isEmpty((CharSequence)from)) {
            throw new BadRequestException("Field from is not specified");
        }
        String subject = document.get("subject").asString();
        if (StringUtils.isEmpty((CharSequence)subject)) {
            throw new BadRequestException("Field subject is not specified");
        }
        String messageBody = document.get("body").asString();
        if (StringUtils.isEmpty((CharSequence)messageBody)) {
            throw new BadRequestException("Field message is not specified");
        }
        Properties props = new Properties();
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.starttls.enable", "true");
        props.put("mail.smtp.host", this.host);
        props.put("mail.smtp.port", this.port);
        Session session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(ExampleEmailService.this.username, ExampleEmailService.this.password);
            }
        });
        try {
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(from));
            message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to));
            message.setSubject(subject);
            message.setContent((Object)messageBody, "text/html; charset=UTF-8");
            Transport.send((Message)message);
            LOGGER.debug("Email sent to " + to);
        }
        catch (MessagingException mE) {
            throw new InternalServerErrorException((Throwable)mE);
        }
        return JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"status", (Object)"okay")}));
    }

    public Promise<ResourceResponse, ResourceException> patchInstance(Context context, PatchRequest request) {
        return new NotSupportedException().asPromise();
    }

    public Promise<ResourceResponse, ResourceException> readInstance(Context context, ReadRequest request) {
        return new NotSupportedException().asPromise();
    }

    public Promise<ResourceResponse, ResourceException> updateInstance(Context context, UpdateRequest request) {
        return new NotSupportedException().asPromise();
    }
}

