/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.script.javascript.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.forgerock.script.engine.ScriptEngineFactory;
import org.forgerock.script.javascript.RhinoScriptEngineFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator,
ServiceFactory<ScriptEngineFactory> {
    private ServiceRegistration<?> serviceRegistration = null;
    private static final ConcurrentMap<Bundle, ScriptEngineFactory> REGISTRY = new ConcurrentHashMap<Bundle, ScriptEngineFactory>();

    public void start(BundleContext context) throws Exception {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("service.vendor", "ForgeRock AS");
        ((Dictionary)properties).put("service.description", "Scripting language support of ECMAScript");
        this.serviceRegistration = context.registerService(ScriptEngineFactory.class.getName(), (Object)this, properties);
    }

    public void stop(BundleContext context) throws Exception {
        if (null != this.serviceRegistration) {
            this.serviceRegistration.unregister();
            this.serviceRegistration = null;
        }
    }

    public ScriptEngineFactory getService(Bundle bundle, ServiceRegistration<ScriptEngineFactory> registration) {
        RhinoScriptEngineFactory factory = new RhinoScriptEngineFactory();
        ScriptEngineFactory result = REGISTRY.putIfAbsent(bundle, factory);
        if (null == result) {
            result = factory;
        }
        return result;
    }

    public void ungetService(Bundle bundle, ServiceRegistration<ScriptEngineFactory> registration, ScriptEngineFactory service) {
        REGISTRY.remove(bundle);
    }
}

