/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.script.javascript;

import java.util.Map;
import org.forgerock.json.JsonValue;
import org.forgerock.script.javascript.Converter;
import org.forgerock.script.scope.AbstractFactory;
import org.forgerock.script.scope.Parameter;
import org.forgerock.util.Factory;
import org.forgerock.util.LazyMap;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Wrapper;

class ScriptableMap
extends NativeObject
implements Wrapper {
    private static final long serialVersionUID = 1L;
    private final transient Parameter parameter;
    private final Map<String, Object> map;

    public ScriptableMap(AbstractFactory.MapFactory factory) {
        if (null == factory) {
            throw new NullPointerException();
        }
        this.parameter = factory.getParameter();
        this.map = new LazyMap((Factory)factory);
    }

    public ScriptableMap(Parameter parameter, Map<String, Object> map) {
        if (null == map) {
            throw new NullPointerException();
        }
        this.parameter = parameter;
        this.map = map;
    }

    public String getClassName() {
        return "ScriptableMap";
    }

    public Object get(String name, Scriptable start) {
        if (this.map.containsKey(name)) {
            return Converter.wrap(this.parameter, this.map.get(name), start, this.map instanceof LazyMap);
        }
        return NOT_FOUND;
    }

    public Object get(int index, Scriptable start) {
        return this.has(index, start) ? this.get(Integer.toString(index), start) : super.get(index, start);
    }

    public boolean has(String name, Scriptable start) {
        return this.map.containsKey(name);
    }

    public boolean has(int index, Scriptable start) {
        return this.has(Integer.toString(index), start);
    }

    public void put(String name, Scriptable start, Object value) {
        try {
            this.map.put(name, Converter.convert(value));
        }
        catch (Exception e) {
            throw Context.reportRuntimeError((String)"map prohibits modification");
        }
    }

    public void put(int index, Scriptable start, Object value) {
        this.put(Integer.toString(index), start, value);
    }

    public void delete(String name) {
        try {
            this.map.remove(name);
        }
        catch (Exception e) {
            throw Context.reportRuntimeError((String)"map prohibits modification");
        }
    }

    public void delete(int index) {
        this.delete(Integer.toString(index));
    }

    public Object[] getIds() {
        return this.map.keySet().toArray();
    }

    public Object getDefaultValue(Class<?> hint) {
        if (hint == null || hint == String.class) {
            return this.toString();
        }
        if (hint == Number.class) {
            return Double.NaN;
        }
        if (hint == Boolean.class) {
            return Boolean.TRUE;
        }
        return this;
    }

    public boolean hasInstance(Scriptable instance) {
        return false;
    }

    public Object unwrap() {
        return this.map;
    }

    public String toString() {
        return this.map == null ? "null" : new JsonValue(this.map).toString();
    }
}

