/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.script.javascript;

import java.util.Collections;
import java.util.List;
import org.forgerock.json.JsonValue;
import org.forgerock.script.javascript.Converter;
import org.forgerock.script.scope.AbstractFactory;
import org.forgerock.script.scope.Parameter;
import org.forgerock.util.Factory;
import org.forgerock.util.LazyList;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.TopLevel;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

class ScriptableList
extends IdScriptableObject
implements Wrapper {
    static final long serialVersionUID = 1L;
    private static final Object ARRAY_TAG = "ScriptableList";
    private int lengthAttr = 6;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toLocaleString = 3;
    private static final int Id_toSource = 4;
    private static final int Id_join = 5;
    private static final int Id_reverse = 6;
    private static final int Id_sort = 7;
    private static final int Id_push = 8;
    private static final int Id_pop = 9;
    private static final int Id_shift = 10;
    private static final int Id_unshift = 11;
    private static final int Id_splice = 12;
    private static final int Id_concat = 13;
    private static final int Id_slice = 14;
    private static final int Id_indexOf = 15;
    private static final int Id_lastIndexOf = 16;
    private static final int Id_every = 17;
    private static final int Id_filter = 18;
    private static final int Id_forEach = 19;
    private static final int Id_map = 20;
    private static final int Id_some = 21;
    private static final int Id_reduce = 22;
    private static final int Id_reduceRight = 23;
    private static final int MAX_PROTOTYPE_ID = 23;
    private static final int ConstructorId_join = -5;
    private static final int ConstructorId_reverse = -6;
    private static final int ConstructorId_sort = -7;
    private static final int ConstructorId_push = -8;
    private static final int ConstructorId_pop = -9;
    private static final int ConstructorId_shift = -10;
    private static final int ConstructorId_unshift = -11;
    private static final int ConstructorId_splice = -12;
    private static final int ConstructorId_concat = -13;
    private static final int ConstructorId_slice = -14;
    private static final int ConstructorId_indexOf = -15;
    private static final int ConstructorId_lastIndexOf = -16;
    private static final int ConstructorId_every = -17;
    private static final int ConstructorId_filter = -18;
    private static final int ConstructorId_forEach = -19;
    private static final int ConstructorId_map = -20;
    private static final int ConstructorId_some = -21;
    private static final int ConstructorId_reduce = -22;
    private static final int ConstructorId_reduceRight = -23;
    private static final int ConstructorId_isArray = -24;
    private static final int Id_length = 1;
    private static final int MAX_INSTANCE_ID = 1;
    private static final Integer NEGATIVE_ONE = -1;
    private final Parameter parameter;
    private final List<Object> list;

    private ScriptableList() {
        this.list = Collections.emptyList();
        this.parameter = null;
    }

    static void init(Scriptable scope, boolean sealed) {
        ScriptableList obj = new ScriptableList();
        obj.exportAsJSClass(23, scope, sealed);
    }

    public String getClassName() {
        return "ScriptableList";
    }

    public String toString() {
        return null == this.list ? "null" : new JsonValue(this.list).toString();
    }

    protected void fillConstructorProperties(IdFunctionObject ctor) {
        this.addIdFunctionProperty((Scriptable)ctor, ARRAY_TAG, -5, "join", 1);
        this.addIdFunctionProperty((Scriptable)ctor, ARRAY_TAG, -6, "reverse", 0);
        this.addIdFunctionProperty((Scriptable)ctor, ARRAY_TAG, -7, "sort", 1);
        this.addIdFunctionProperty((Scriptable)ctor, ARRAY_TAG, -8, "push", 1);
        this.addIdFunctionProperty((Scriptable)ctor, ARRAY_TAG, -9, "pop", 0);
        this.addIdFunctionProperty((Scriptable)ctor, ARRAY_TAG, -10, "shift", 0);
        this.addIdFunctionProperty((Scriptable)ctor, ARRAY_TAG, -11, "unshift", 1);
        this.addIdFunctionProperty((Scriptable)ctor, ARRAY_TAG, -12, "splice", 2);
        this.addIdFunctionProperty((Scriptable)ctor, ARRAY_TAG, -13, "concat", 1);
        this.addIdFunctionProperty((Scriptable)ctor, ARRAY_TAG, -14, "slice", 2);
        this.addIdFunctionProperty((Scriptable)ctor, ARRAY_TAG, -15, "indexOf", 1);
        this.addIdFunctionProperty((Scriptable)ctor, ARRAY_TAG, -16, "lastIndexOf", 1);
        this.addIdFunctionProperty((Scriptable)ctor, ARRAY_TAG, -17, "every", 1);
        this.addIdFunctionProperty((Scriptable)ctor, ARRAY_TAG, -18, "filter", 1);
        this.addIdFunctionProperty((Scriptable)ctor, ARRAY_TAG, -19, "forEach", 1);
        this.addIdFunctionProperty((Scriptable)ctor, ARRAY_TAG, -20, "map", 1);
        this.addIdFunctionProperty((Scriptable)ctor, ARRAY_TAG, -21, "some", 1);
        this.addIdFunctionProperty((Scriptable)ctor, ARRAY_TAG, -22, "reduce", 1);
        this.addIdFunctionProperty((Scriptable)ctor, ARRAY_TAG, -23, "reduceRight", 1);
        this.addIdFunctionProperty((Scriptable)ctor, ARRAY_TAG, -24, "isArray", 1);
        super.fillConstructorProperties(ctor);
    }

    protected void initPrototypeId(int id) {
        String s;
        int arity;
        switch (id) {
            case 1: {
                arity = 1;
                s = "constructor";
                break;
            }
            case 2: {
                arity = 0;
                s = "toString";
                break;
            }
            case 3: {
                arity = 0;
                s = "toLocaleString";
                break;
            }
            case 4: {
                arity = 0;
                s = "toSource";
                break;
            }
            case 5: {
                arity = 1;
                s = "join";
                break;
            }
            case 6: {
                arity = 0;
                s = "reverse";
                break;
            }
            case 7: {
                arity = 1;
                s = "sort";
                break;
            }
            case 8: {
                arity = 1;
                s = "push";
                break;
            }
            case 9: {
                arity = 0;
                s = "pop";
                break;
            }
            case 10: {
                arity = 0;
                s = "shift";
                break;
            }
            case 11: {
                arity = 1;
                s = "unshift";
                break;
            }
            case 12: {
                arity = 2;
                s = "splice";
                break;
            }
            case 13: {
                arity = 1;
                s = "concat";
                break;
            }
            case 14: {
                arity = 2;
                s = "slice";
                break;
            }
            case 15: {
                arity = 1;
                s = "indexOf";
                break;
            }
            case 16: {
                arity = 1;
                s = "lastIndexOf";
                break;
            }
            case 17: {
                arity = 1;
                s = "every";
                break;
            }
            case 18: {
                arity = 1;
                s = "filter";
                break;
            }
            case 19: {
                arity = 1;
                s = "forEach";
                break;
            }
            case 20: {
                arity = 1;
                s = "map";
                break;
            }
            case 21: {
                arity = 1;
                s = "some";
                break;
            }
            case 22: {
                arity = 1;
                s = "reduce";
                break;
            }
            case 23: {
                arity = 1;
                s = "reduceRight";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(id));
            }
        }
        this.initPrototypeMethod(ARRAY_TAG, id, s, arity);
    }

    public ScriptableList(AbstractFactory.ListFactory factory) {
        if (null == factory) {
            throw new NullPointerException();
        }
        this.list = new LazyList((Factory)factory);
        this.parameter = factory.getParameter();
    }

    public ScriptableList(Parameter operationParameter, List<Object> list) {
        if (null == operationParameter) {
            throw new NullPointerException();
        }
        if (null == list) {
            throw new NullPointerException();
        }
        this.list = list;
        this.parameter = operationParameter;
    }

    protected int getMaxInstanceId() {
        return 1;
    }

    protected void setInstanceIdAttributes(int id, int attr) {
        if (id == 1) {
            this.lengthAttr = attr;
        }
    }

    protected int findInstanceIdInfo(String s) {
        if (s.equals("length")) {
            return ScriptableList.instanceIdInfo((int)this.lengthAttr, (int)1);
        }
        return super.findInstanceIdInfo(s);
    }

    protected String getInstanceIdName(int id) {
        if (id == 1) {
            return "length";
        }
        return super.getInstanceIdName(id);
    }

    protected Object getInstanceIdValue(int id) {
        if (id == 1) {
            return ScriptRuntime.wrapNumber((double)this.getLength());
        }
        return super.getInstanceIdValue(id);
    }

    protected void setInstanceIdValue(int id, Object value) {
        if (id == 1) {
            return;
        }
        super.setInstanceIdValue(id, value);
    }

    public int getAttributes(int index) {
        if (index >= 0 && (long)index < this.getLength() && this.list.get(index) != null) {
            return 0;
        }
        return super.getAttributes(index);
    }

    protected ScriptableObject getOwnPropertyDescriptor(Context cx, Object id) {
        if (!this.list.isEmpty()) {
            try {
                int index = Integer.parseInt((String)id);
                Object value = this.list.get(index);
                if (value != null || value != NOT_FOUND) {
                    return this.defaultIndexPropertyDescriptor(value);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return super.getOwnPropertyDescriptor(cx, id);
    }

    private ScriptableObject defaultIndexPropertyDescriptor(Object value) {
        Object scope = this.getParentScope();
        if (scope == null) {
            scope = this;
        }
        NativeObject desc = new NativeObject();
        ScriptRuntime.setBuiltinProtoAndParent((ScriptableObject)desc, (Scriptable)scope, (TopLevel.Builtins)TopLevel.Builtins.Object);
        desc.defineProperty("value", value, 0);
        desc.defineProperty("writable", (Object)true, 0);
        desc.defineProperty("enumerable", (Object)true, 0);
        desc.defineProperty("configurable", (Object)true, 0);
        return desc;
    }

    public Object get(int index, Scriptable start) {
        if (this.isGetterOrSetter(null, index, false)) {
            return super.get(index, start);
        }
        try {
            return Converter.wrap(this.parameter, this.list.get(index), start, this.list instanceof LazyList);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return super.get(index, start);
        }
    }

    public boolean has(int index, Scriptable start) {
        if (this.isGetterOrSetter(null, index, false)) {
            return super.has(index, start);
        }
        if (0 <= index && (long)index < this.getLength()) {
            return this.list.get(index) != null;
        }
        return super.has(index, start);
    }

    public Object get(String name, Scriptable start) {
        Object o = super.get(name, start);
        return o;
    }

    public boolean has(String name, Scriptable start) {
        return "length".equals(name);
    }

    public void put(String name, Scriptable start, Object value) {
        if ("length".equals(name)) {
            if (!(value instanceof Number)) {
                throw Context.reportRuntimeError((String)"invalid array length");
            }
            int length = ((Number)value).intValue();
            if (length < 0) {
                throw Context.reportRuntimeError((String)"invalid array length");
            }
            this.resize(length);
        }
    }

    public void delete(String name) {
    }

    public void put(int index, Scriptable start, Object value) {
        if (index < 0) {
            throw Context.reportRuntimeError((String)"index out of bounds");
        }
        if (this.list.size() < index + 1) {
            this.resize(index + 1);
        }
        value = Converter.convert(value);
        try {
            if (index < this.list.size()) {
                this.list.set(index, value);
            } else {
                this.list.add(value);
            }
        }
        catch (Exception e) {
            throw Context.reportRuntimeError((String)"list prohibits modification");
        }
    }

    public void delete(int index) {
        if (index >= 0 && index < this.list.size()) {
            try {
                this.list.set(index, null);
            }
            catch (Exception e) {
                throw Context.reportRuntimeError((String)"list prohibits modification");
            }
        }
    }

    public Object[] getIds() {
        Object[] result = new Object[this.list.size()];
        for (int n = 0; n < result.length; ++n) {
            result[n] = n;
        }
        return result;
    }

    public Object getDefaultValue(Class<?> hint) {
        if (hint == null || hint == String.class) {
            return this.toString();
        }
        if (hint == Number.class) {
            return Double.NaN;
        }
        if (hint == Boolean.class) {
            return Boolean.TRUE;
        }
        return this;
    }

    public boolean hasInstance(Scriptable instance) {
        return false;
    }

    public Object unwrap() {
        return this.list;
    }

    public Object execIdCall(IdFunctionObject f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!f.hasTag(ARRAY_TAG)) {
            return super.execIdCall(f, cx, scope, thisObj, args);
        }
        int id = f.methodId();
        block22: while (true) {
            switch (id) {
                case -23: 
                case -22: 
                case -21: 
                case -20: 
                case -19: 
                case -18: 
                case -17: 
                case -16: 
                case -15: 
                case -14: 
                case -13: 
                case -12: 
                case -11: 
                case -10: 
                case -9: 
                case -8: 
                case -7: 
                case -6: 
                case -5: {
                    if (args.length > 0) {
                        thisObj = ScriptRuntime.toObject((Scriptable)scope, (Object)args[0]);
                        Object[] newArgs = new Object[args.length - 1];
                        for (int i = 0; i < newArgs.length; ++i) {
                            newArgs[i] = args[i + 1];
                        }
                        args = newArgs;
                    }
                    id = -id;
                    continue block22;
                }
                case -24: {
                    return args.length > 0 && args[0] instanceof NativeArray;
                }
                case 1: {
                    boolean inNewExpr;
                    boolean bl = inNewExpr = thisObj == null;
                    if (!inNewExpr) {
                        return f.construct(cx, scope, args);
                    }
                    throw ScriptRuntime.throwError((Context)cx, (Scriptable)this, (String)"Constructor is not implemented");
                }
                case 2: {
                    return new JsonValue(this.list).toString();
                }
                case 3: {
                    return new JsonValue(this.list).toString();
                }
                case 4: {
                    return new JsonValue(this.list).toString();
                }
                case 5: {
                    return this.js_join(cx, thisObj, args);
                }
                case 6: {
                    throw ScriptRuntime.throwError((Context)cx, (Scriptable)this, (String)"reverse is not implemented");
                }
                case 7: {
                    throw ScriptRuntime.throwError((Context)cx, (Scriptable)this, (String)"sort is not implemented");
                }
                case 8: {
                    throw ScriptRuntime.throwError((Context)cx, (Scriptable)this, (String)"push is not implemented");
                }
                case 9: {
                    throw ScriptRuntime.throwError((Context)cx, (Scriptable)this, (String)"pop is not implemented");
                }
                case 10: {
                    throw ScriptRuntime.throwError((Context)cx, (Scriptable)this, (String)"shift is not implemented");
                }
                case 11: {
                    throw ScriptRuntime.throwError((Context)cx, (Scriptable)this, (String)"unshift is not implemented");
                }
                case 12: {
                    throw ScriptRuntime.throwError((Context)cx, (Scriptable)this, (String)"splice is not implemented");
                }
                case 13: {
                    throw ScriptRuntime.throwError((Context)cx, (Scriptable)this, (String)"concat is not implemented");
                }
                case 14: {
                    throw ScriptRuntime.throwError((Context)cx, (Scriptable)this, (String)"slice is not implemented");
                }
                case 15: {
                    return this.indexOfHelper(cx, thisObj, args, false);
                }
                case 16: {
                    return this.indexOfHelper(cx, thisObj, args, true);
                }
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    throw ScriptRuntime.throwError((Context)cx, (Scriptable)this, (String)"some is not implemented");
                }
                case 22: 
                case 23: {
                    throw ScriptRuntime.throwError((Context)cx, (Scriptable)this, (String)"reduceRight is not implemented");
                }
            }
            break;
        }
        throw new IllegalArgumentException(String.valueOf(id));
    }

    protected void resize(int size) {
        while (this.list.size() < size) {
            try {
                this.list.add(null);
            }
            catch (Exception e) {
                throw Context.reportRuntimeError((String)"list prohibits addition of null elements");
            }
        }
        while (this.list.size() > size) {
            try {
                this.list.remove(size);
            }
            catch (Exception e) {
                throw Context.reportRuntimeError((String)"list prohibits element removal");
            }
        }
    }

    public long getLength() {
        return ScriptRuntime.toUint32((double)this.list.size());
    }

    protected Object indexOfHelper(Context cx, Scriptable thisObj, Object[] args, boolean isLast) {
        if (thisObj instanceof ScriptableList) {
            long start;
            ScriptableList scriptableList = (ScriptableList)thisObj;
            Object compareTo = args.length > 0 ? args[0] : Undefined.instance;
            long length = scriptableList.getLength();
            if (isLast) {
                if (args.length < 2) {
                    start = length - 1L;
                } else {
                    start = (long)ScriptRuntime.toInteger((Object)args[1]);
                    if (start >= length) {
                        start = length - 1L;
                    } else if (start < 0L) {
                        start += length;
                    }
                    if (start < 0L) {
                        return NEGATIVE_ONE;
                    }
                }
            } else if (args.length < 2) {
                start = 0L;
            } else {
                start = (long)ScriptRuntime.toInteger((Object)args[1]);
                if (start < 0L && (start += length) < 0L) {
                    start = 0L;
                }
                if (start > length - 1L) {
                    return NEGATIVE_ONE;
                }
            }
            if (isLast) {
                for (int i = (int)start; i >= 0; --i) {
                    if (scriptableList.list.get(i) == Scriptable.NOT_FOUND || !ScriptRuntime.shallowEq((Object)scriptableList.list.get(i), (Object)compareTo)) continue;
                    return (long)i;
                }
            } else {
                int i = (int)start;
                while ((long)i < length) {
                    if (scriptableList.list.get(i) != Scriptable.NOT_FOUND && ScriptRuntime.shallowEq((Object)scriptableList.list.get(i), (Object)compareTo)) {
                        return (long)i;
                    }
                    ++i;
                }
            }
            return NEGATIVE_ONE;
        }
        if (thisObj instanceof NativeArray) {
            throw ScriptRuntime.throwError((Context)cx, (Scriptable)this, (String)"Can not delegate the method to super NativeArray");
        }
        throw ScriptRuntime.throwError((Context)cx, (Scriptable)this, (String)"Can not delegate the method to super NativeArray");
    }

    private String js_join(Context cx, Scriptable thisObj, Object[] args) {
        if (thisObj instanceof ScriptableList) {
            int length;
            ScriptableList scriptableList = (ScriptableList)thisObj;
            long llength = scriptableList.getLength();
            if (llength != (long)(length = (int)llength)) {
                throw Context.reportRuntimeError((String)ScriptRuntime.getMessage1((String)"msg.arraylength.too.big", (Object)String.valueOf(llength)));
            }
            String separator = args.length < 1 || args[0] == Undefined.instance ? "," : ScriptRuntime.toString((Object)args[0]);
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Object temp : scriptableList.list) {
                if (temp == null || temp == Undefined.instance || temp == Scriptable.NOT_FOUND) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(separator);
                }
                sb.append(ScriptRuntime.toString((Object)temp));
            }
            return sb.toString();
        }
        if (thisObj instanceof NativeArray) {
            ScriptRuntime.throwError((Context)cx, (Scriptable)this, (String)"Can not delegate the method to super NativeArray");
            IdFunctionObject f = null;
            return ScriptRuntime.toString((Object)((NativeArray)thisObj).execIdCall(f, cx, (Scriptable)this, thisObj, args));
        }
        ScriptRuntime.throwError((Context)cx, (Scriptable)this, (String)"Can not delegate the method to super NativeArray");
        return "";
    }
}

