/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.script.javascript;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.script.javascript.Converter;
import org.forgerock.script.scope.Function;
import org.forgerock.script.scope.OperationParameter;
import org.forgerock.script.scope.Parameter;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.Wrapper;

class ScriptableFunction
extends BaseFunction
implements Wrapper {
    private static final long serialVersionUID = 1L;
    private final AtomicReference<Parameter> parameter;
    private final Function<?> function;

    ScriptableFunction(Parameter operationParameter, Function<?> function) {
        this.function = function;
        this.parameter = new AtomicReference<Parameter>(operationParameter);
    }

    ScriptableFunction(Scriptable scope, Scriptable prototype, OperationParameter operationParameter, Function<?> function) {
        super(scope, prototype);
        this.function = function;
        this.parameter = new AtomicReference<OperationParameter>(operationParameter);
    }

    private List<Object> convert(Object[] args) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object object : args) {
            if (object instanceof BaseFunction) continue;
            list.add(Converter.convert(object));
        }
        return list;
    }

    public Object call(final Context cx, final Scriptable scope, final Scriptable thisObj, Object[] args) {
        try {
            Object result;
            Object[] arguments = args;
            Function<Void> callbackFunction = null;
            if (args.length > 0 && args[args.length - 1] instanceof NativeFunction) {
                final BaseFunction nativeFunction = (BaseFunction)args[args.length - 1];
                callbackFunction = nativeFunction instanceof ScriptableFunction ? ((ScriptableFunction)nativeFunction).function : new Function<Void>(){

                    public Void call(Parameter scope0, Function<?> callback, Object ... arguments) throws ResourceException, NoSuchMethodException {
                        try {
                            nativeFunction.call(cx, scope, thisObj, arguments);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return null;
                    }
                };
                arguments = Arrays.copyOfRange(args, 0, args.length - 1);
            }
            if (null == (result = this.function.call(this.getParameter(), callbackFunction, this.convert(arguments).toArray()))) {
                return null;
            }
            if (result instanceof JsonValue) {
                return Converter.wrap(this.getParameter(), ((JsonValue)result).getObject(), scope, false);
            }
            return Converter.wrap(this.getParameter(), result, scope, false);
        }
        catch (Throwable throwable) {
            throw new WrappedException(throwable);
        }
    }

    protected Parameter getParameter() {
        Parameter p = this.parameter.get();
        if (null == p) {
            Object o = Context.getCurrentContext().getThreadLocal((Object)Parameter.class.getName());
            if (o instanceof Parameter) {
                this.parameter.lazySet(p);
                return p;
            }
        } else {
            return p;
        }
        return null;
    }

    public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        throw Context.reportRuntimeError((String)"functions may not be used as constructors");
    }

    public String getTypeOf() {
        return this.avoidObjectDetection() ? "undefined" : "function";
    }

    public Object get(int index, Scriptable start) {
        return NOT_FOUND;
    }

    public boolean has(String name, Scriptable start) {
        return false;
    }

    public boolean has(int index, Scriptable start) {
        return false;
    }

    public void put(String name, Scriptable start, Object value) {
        throw Context.reportRuntimeError((String)"function prohibits modification");
    }

    public void put(int index, Scriptable start, Object value) {
        throw Context.reportRuntimeError((String)"function prohibits modification");
    }

    public void delete(String name) {
        throw Context.reportRuntimeError((String)"function prohibits modification");
    }

    public void delete(int index) {
        throw Context.reportRuntimeError((String)"function prohibits modification");
    }

    public Object[] getIds() {
        return new Object[0];
    }

    public Object getDefaultValue(Class<?> hint) {
        return this;
    }

    public boolean hasInstance(Scriptable instance) {
        return false;
    }

    public Object unwrap() {
        return this.function;
    }
}

