/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.script.javascript;

import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.script.Bindings;
import javax.script.ScriptException;
import org.eclipse.wst.jsdt.debug.rhino.debugger.RhinoDebugger;
import org.forgerock.script.engine.AbstractScriptEngine;
import org.forgerock.script.engine.CompilationHandler;
import org.forgerock.script.engine.CompiledScript;
import org.forgerock.script.engine.ScriptEngineFactory;
import org.forgerock.script.exception.ScriptCompilationException;
import org.forgerock.script.javascript.RhinoScript;
import org.forgerock.script.scope.OperationParameter;
import org.forgerock.script.source.ScriptSource;
import org.forgerock.script.source.SourceContainer;
import org.forgerock.script.source.URLScriptSource;
import org.forgerock.services.context.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.commonjs.module.ModuleScriptProvider;
import org.mozilla.javascript.commonjs.module.RequireBuilder;
import org.mozilla.javascript.commonjs.module.provider.DefaultUrlConnectionExpiryCalculator;
import org.mozilla.javascript.commonjs.module.provider.ModuleSourceProvider;
import org.mozilla.javascript.commonjs.module.provider.SoftCachingModuleScriptProvider;
import org.mozilla.javascript.commonjs.module.provider.UrlConnectionExpiryCalculator;
import org.mozilla.javascript.commonjs.module.provider.UrlModuleSourceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RhinoScriptEngine
extends AbstractScriptEngine {
    private static final Logger logger = LoggerFactory.getLogger(RhinoScriptEngine.class);
    private ScriptEngineFactory factory;
    private final ConcurrentMap<String, ScriptCacheEntry> scriptCache = new ConcurrentHashMap<String, ScriptCacheEntry>();
    private long minimumRecompilationInterval = -1L;
    private RequireBuilder requireBuilder;
    private ClassLoader classLoader;
    private ContextFactory.Listener debugListener = null;
    private volatile Boolean debugInitialised = null;
    public static final String CONFIG_DEBUG_PROPERTY = "javascript.debug";
    public static final String CONFIG_RECOMPILE_MINIMUM_INTERVAL_PROPERTY = "javascript.recompile.minimumInterval";

    RhinoScriptEngine(Map<String, Object> configuration, ScriptEngineFactory factory, final Collection<SourceContainer> sourceContainers, ClassLoader registryLevelClassLoader) {
        Object recompile;
        this.factory = factory;
        Object debugProperty = configuration.get(CONFIG_DEBUG_PROPERTY);
        if (debugProperty instanceof String) {
            this.initDebugListener((String)debugProperty);
        }
        if ((recompile = configuration.get(CONFIG_RECOMPILE_MINIMUM_INTERVAL_PROPERTY)) instanceof String) {
            this.minimumRecompilationInterval = Long.valueOf((String)recompile);
        }
        Iterable<URI> sourceContainerURIIterable = new Iterable<URI>(){

            @Override
            public Iterator<URI> iterator() {
                final Iterator iter = sourceContainers.iterator();
                return new Iterator<URI>(){

                    @Override
                    public boolean hasNext() {
                        return iter.hasNext();
                    }

                    @Override
                    public URI next() {
                        return ((SourceContainer)iter.next()).getSourceURI();
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
        UrlModuleSourceProvider sourceProvider = new UrlModuleSourceProvider((Iterable)sourceContainerURIIterable, null, (UrlConnectionExpiryCalculator)(this.minimumRecompilationInterval < 0L ? new DefaultUrlConnectionExpiryCalculator(0L) : new DefaultUrlConnectionExpiryCalculator(this.minimumRecompilationInterval)), null);
        SoftCachingModuleScriptProvider scriptProvider = new SoftCachingModuleScriptProvider((ModuleSourceProvider)sourceProvider);
        this.requireBuilder = new RequireBuilder();
        this.requireBuilder.setModuleScriptProvider((ModuleScriptProvider)scriptProvider);
        this.classLoader = registryLevelClassLoader != null ? registryLevelClassLoader : RhinoScriptEngine.class.getClassLoader();
    }

    protected ScriptCacheEntry isSourceNewer(String name, ScriptCacheEntry entry) throws ScriptException {
        long now;
        if (this.minimumRecompilationInterval < 0L) {
            return entry;
        }
        long nextSourceCheck = entry.lastCheck + this.minimumRecompilationInterval;
        if (nextSourceCheck < (now = System.currentTimeMillis())) {
            long newModified = URLScriptSource.getURLRevision((URL)entry.scriptSource.getSource(), null);
            if (entry.lastModified < newModified) {
                ConcurrentMap<String, ScriptCacheEntry> concurrentMap = this.scriptCache;
                synchronized (concurrentMap) {
                    try {
                        Script recompiled = this.compileScript(name, entry.scriptSource.getReader());
                        ScriptCacheEntry newEntry = new ScriptCacheEntry(recompiled, entry.scriptSource, newModified, now);
                        this.scriptCache.put(name, newEntry);
                        return newEntry;
                    }
                    catch (IOException e) {
                        throw new ScriptException(e);
                    }
                }
            }
        }
        return entry;
    }

    Script createScript(String scriptName) throws ScriptException {
        ScriptCacheEntry entry = (ScriptCacheEntry)this.scriptCache.get(scriptName);
        if (null != entry) {
            return this.isSourceNewer(scriptName, entry).compiledScript;
        }
        throw new ScriptException("Script is not found:" + scriptName);
    }

    public void compileScript(CompilationHandler handler) throws ScriptException {
        try {
            boolean sharedScope = true;
            handler.setClassLoader(this.classLoader);
            RhinoScript rhinoScript = null;
            if (handler.getScriptSource() instanceof URLScriptSource) {
                URLScriptSource source = (URLScriptSource)handler.getScriptSource();
                String name = source.getName().getName();
                if (null != source.getSource() && "file".equals(source.getSource().getProtocol())) {
                    name = URLDecoder.decode(source.getSource().getFile(), "utf-8");
                }
                Script script = this.compileScript(name, source.getReader());
                long now = System.currentTimeMillis();
                this.scriptCache.put(name, new ScriptCacheEntry(script, (ScriptSource)source, now, now));
                rhinoScript = new RhinoScript(name, this, this.requireBuilder, sharedScope);
            } else {
                ScriptSource source = handler.getScriptSource();
                String name = source.getName().getName();
                Script script = this.compileScript(name, source.getReader());
                rhinoScript = new RhinoScript(name, script, this, this.requireBuilder, sharedScope);
            }
            handler.setCompiledScript((CompiledScript)rhinoScript);
        }
        catch (ScriptException e) {
            handler.handleException((Exception)e);
            throw e;
        }
        catch (Exception e) {
            handler.handleException(e);
            throw new ScriptException(e);
        }
    }

    private Script compileScript(String name, Reader scriptReader) throws ScriptCompilationException {
        org.mozilla.javascript.Context cx = org.mozilla.javascript.Context.enter();
        try {
            Script script = cx.compileReader(scriptReader, name, 1, null);
            return script;
        }
        catch (IOException ioe) {
            throw new ScriptCompilationException(ioe.getMessage(), (Exception)ioe);
        }
        catch (RhinoException re) {
            throw new ScriptCompilationException(re.getMessage(), (Exception)((Object)re), re.sourceName(), re.lineNumber(), re.columnNumber());
        }
        finally {
            org.mozilla.javascript.Context.exit();
            if (scriptReader != null) {
                try {
                    scriptReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public ScriptEngineFactory getFactory() {
        return this.factory;
    }

    public OperationParameter getOperationParameter(Context context) {
        return new OperationParameter(context);
    }

    private synchronized void initDebugListener(String configString) {
        if (null == this.debugInitialised) {
            if (null != configString) {
                try {
                    if (null == this.debugListener) {
                        this.debugListener = new RhinoDebugger(configString);
                        org.mozilla.javascript.Context.enter().getFactory().addListener(this.debugListener);
                        org.mozilla.javascript.Context.exit();
                    }
                    ((RhinoDebugger)this.debugListener).start();
                    this.debugInitialised = Boolean.TRUE;
                }
                catch (Throwable ex) {
                    if (!(ex instanceof NoClassDefFoundError)) {
                        logger.error("RhinoDebugger can not be started", ex);
                    }
                    logger.warn("RhinoDebugger can not be started because the JSDT RhinoDebugger and Transport bundles must be deployed.");
                }
                this.debugInitialised = null == this.debugInitialised ? Boolean.FALSE : this.debugInitialised;
            } else {
                this.debugInitialised = Boolean.FALSE;
            }
        }
    }

    public Bindings compileBindings(Context context, Bindings request, Bindings ... value) {
        return null;
    }

    private static final class ScriptCacheEntry {
        private final Script compiledScript;
        private final ScriptSource scriptSource;
        private final long lastModified;
        private final long lastCheck;

        private ScriptCacheEntry(Script compiledScript, ScriptSource scriptSource, long lastModified, long lastCheck) {
            this.compiledScript = compiledScript;
            this.scriptSource = scriptSource;
            this.lastModified = lastModified;
            this.lastCheck = lastCheck;
        }
    }
}

