/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.script.javascript;

import java.io.IOException;
import java.io.InputStream;
import java.security.SecureClassLoader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.script.engine.CompiledScript;
import org.forgerock.script.engine.Utils;
import org.forgerock.script.exception.ScriptThrownException;
import org.forgerock.script.javascript.Converter;
import org.forgerock.script.javascript.RhinoScriptEngine;
import org.forgerock.script.registry.ThreadClassLoaderManager;
import org.forgerock.script.scope.FunctionFactory;
import org.forgerock.script.scope.OperationParameter;
import org.forgerock.script.scope.Parameter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.commonjs.module.RequireBuilder;
import org.mozilla.javascript.tools.shell.Global;
import org.mozilla.javascript.tools.shell.QuitAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RhinoScript
implements CompiledScript {
    static final Logger logger = LoggerFactory.getLogger(RhinoScript.class);
    private ScriptableObject topSharedScope = null;
    private Scriptable scriptScope = null;
    private final Script script;
    private final String scriptName;
    private final RhinoScriptEngine engine;
    private final RequireBuilder requireBuilder;
    public static final Global GLOBAL = new Global();
    private final boolean sharedScope;

    public RhinoScript(String name, Script compiledScript, RhinoScriptEngine engine, RequireBuilder requireBuilder, boolean sharedScope) throws ScriptException {
        this.scriptName = name;
        this.sharedScope = sharedScope;
        this.engine = engine;
        this.requireBuilder = requireBuilder;
        Context cx = Context.enter();
        try {
            this.scriptScope = this.getScriptScope(cx);
            this.script = compiledScript;
        }
        catch (RhinoException re) {
            throw new ScriptException(re.getMessage());
        }
        finally {
            Context.exit();
        }
    }

    public RhinoScript(String name, RhinoScriptEngine engine, RequireBuilder requireBuilder, boolean sharedScope) throws ScriptException {
        this.scriptName = name;
        this.sharedScope = sharedScope;
        this.engine = engine;
        this.requireBuilder = requireBuilder;
        Context cx = Context.enter();
        try {
            this.scriptScope = this.getScriptScope(cx);
            this.script = null;
        }
        catch (RhinoException re) {
            throw new ScriptException((Exception)((Object)re));
        }
        finally {
            Context.exit();
        }
    }

    private ScriptableObject getStandardObjects(Context context) {
        if (!this.sharedScope) {
            ScriptableObject scope = context.initStandardObjects();
            this.installRequire(context, scope);
            return scope;
        }
        if (this.topSharedScope == null) {
            Global scope = new Global(context);
            scope.initQuitAction((QuitAction)new IProxy());
            context.setApplicationClassLoader((ClassLoader)new InnerClassLoader(context.getApplicationClassLoader()));
            InputStream init = RhinoScript.class.getResourceAsStream("/resources/init.js");
            if (null != init) {
                try {
                    context.evaluateString((Scriptable)scope, Utils.readStream((InputStream)init), "/resources/init.js", 1, null);
                }
                catch (IOException e) {
                    logger.error("Failed to evaluate init.js", (Throwable)e);
                }
            }
            this.addLoggerProperty((Scriptable)scope);
            this.installRequire(context, (ScriptableObject)scope);
            scope.sealObject();
            this.topSharedScope = scope;
        }
        return this.topSharedScope;
    }

    private void installRequire(Context context, ScriptableObject scope) {
        this.requireBuilder.createRequire(context, (Scriptable)scope).install((Scriptable)scope);
    }

    private Scriptable getScriptScope(Context context) {
        ScriptableObject topLevel = this.getStandardObjects(context);
        Scriptable scriptScopeScriptable = context.newObject((Scriptable)topLevel);
        scriptScopeScriptable.setPrototype((Scriptable)topLevel);
        scriptScopeScriptable.setParentScope(null);
        return scriptScopeScriptable;
    }

    private void addLoggerProperty(Scriptable scope) {
        String loggerName = "org.forgerock.script.javascript.JavaScript." + this.trimPath(this.scriptName);
        scope.put("logger", scope, Converter.wrap(null, FunctionFactory.getLogger((String)loggerName), scope, false));
    }

    private String trimPath(String name) {
        return name.indexOf("/") != -1 ? name.substring(name.lastIndexOf("/") + 1) : name;
    }

    public Bindings prepareBindings(org.forgerock.services.context.Context context, Bindings request, Bindings ... scopes) {
        return new SimpleBindings();
    }

    public Object eval(org.forgerock.services.context.Context ctx, Bindings request, Bindings ... scopes) throws ScriptException {
        Context context = Context.enter();
        try {
            Object result;
            Scriptable outer = context.newObject((Scriptable)this.getStandardObjects(context));
            OperationParameter operationParameter = this.engine.getOperationParameter(ctx);
            Context.getCurrentContext().putThreadLocal((Object)Parameter.class.getName(), (Object)operationParameter);
            Set safeAttributes = null != request ? request.keySet() : Collections.EMPTY_SET;
            HashMap scope = new HashMap();
            for (Bindings next : scopes) {
                if (null == next) continue;
                for (Map.Entry entry : next.entrySet()) {
                    if (scope.containsKey(entry.getKey()) || safeAttributes.contains(entry.getKey())) continue;
                    long index = ScriptRuntime.indexFromString((String)((String)entry.getKey()));
                    if (index < 0L) {
                        outer.put((String)entry.getKey(), outer, Converter.wrap((Parameter)operationParameter, entry.getValue(), outer, true));
                        continue;
                    }
                    outer.put((int)index, outer, Converter.wrap((Parameter)operationParameter, entry.getValue(), outer, true));
                }
            }
            if (null != request) {
                for (Map.Entry entry : request.entrySet()) {
                    long index = ScriptRuntime.indexFromString((String)((String)entry.getKey()));
                    if (index < 0L) {
                        outer.put((String)entry.getKey(), outer, Converter.wrap((Parameter)operationParameter, entry.getValue(), outer, false));
                        continue;
                    }
                    outer.put((int)index, outer, Converter.wrap((Parameter)operationParameter, entry.getValue(), outer, false));
                }
            }
            outer.setPrototype(this.scriptScope);
            outer.setParentScope(null);
            Scriptable inner = context.newObject(outer);
            inner.setPrototype(outer);
            inner.setParentScope(null);
            Script script = null != this.script ? this.script : this.engine.createScript(this.scriptName);
            Object object = result = Converter.convert(script.exec(context, inner));
            return object;
        }
        catch (ScriptException e) {
            throw e;
        }
        catch (WrappedException e) {
            if (e.getWrappedException() instanceof ResourceException) {
                throw new ScriptThrownException(e.getMessage(), e.sourceName(), e.lineNumber(), e.columnNumber(), ((ResourceException)e.getWrappedException()).toJsonValue().getObject());
            }
            ScriptThrownException exception = new ScriptThrownException(e.getMessage(), e.sourceName(), e.lineNumber(), e.columnNumber(), (Object)e.getWrappedException());
            exception.initCause(e.getWrappedException());
            throw exception;
        }
        catch (JavaScriptException e) {
            logger.debug("Failed to evaluate {} script.", (Object)this.scriptName, (Object)e);
            ScriptThrownException exception = new ScriptThrownException(e.getMessage(), e.sourceName(), e.lineNumber(), e.columnNumber(), Converter.convert(e.getValue()));
            exception.initCause((Throwable)e);
            throw exception;
        }
        catch (RhinoException e) {
            logger.debug("Failed to evaluate {} script.", (Object)this.scriptName, (Object)e);
            ScriptException exception = new ScriptException(e.getMessage(), e.sourceName(), e.lineNumber(), e.columnNumber());
            exception.initCause(e);
            throw exception;
        }
        catch (Exception e) {
            logger.debug("Failed to evaluate {} script.", (Object)this.scriptName, (Object)e);
            throw new ScriptException(e);
        }
        finally {
            Context.getCurrentContext().removeThreadLocal((Object)Parameter.class.getName());
            Context.exit();
        }
    }

    static {
        GLOBAL.initQuitAction((QuitAction)new IProxy());
    }

    private static class InnerClassLoader
    extends SecureClassLoader {
        public InnerClassLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            Class<?> loadedClass = Kit.classOrNull((ClassLoader)this.getParent(), (String)name);
            if (loadedClass == null) {
                loadedClass = ThreadClassLoaderManager.getInstance().getCurrentClassLoader().loadClass(name);
            }
            return loadedClass;
        }
    }

    private static class IProxy
    implements QuitAction {
        private IProxy() {
        }

        public void quit(Context cx, int exitCode) {
        }
    }
}

