/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.script.javascript;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.DeleteRequest;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.Request;
import org.forgerock.json.resource.UpdateRequest;
import org.forgerock.script.javascript.ScriptableActionRequest;
import org.forgerock.script.javascript.ScriptableContext;
import org.forgerock.script.javascript.ScriptableCreateRequest;
import org.forgerock.script.javascript.ScriptableDeleteRequest;
import org.forgerock.script.javascript.ScriptableFunction;
import org.forgerock.script.javascript.ScriptableList;
import org.forgerock.script.javascript.ScriptableMap;
import org.forgerock.script.javascript.ScriptablePatchRequest;
import org.forgerock.script.javascript.ScriptableQueryRequest;
import org.forgerock.script.javascript.ScriptableReadRequest;
import org.forgerock.script.javascript.ScriptableUpdateRequest;
import org.forgerock.script.scope.AbstractFactory;
import org.forgerock.script.scope.Function;
import org.forgerock.script.scope.Parameter;
import org.forgerock.services.context.Context;
import org.forgerock.util.Factory;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.TopLevel;
import org.mozilla.javascript.Wrapper;

class Converter {
    Converter() {
    }

    private static boolean isInteger(Number number) {
        if (number instanceof Integer || number instanceof Long || number instanceof Byte) {
            return true;
        }
        if (number instanceof Double || number instanceof Float) {
            double d = number.doubleValue();
            return d >= 0.0 && d == Math.floor(d) || d < 0.0 && d == Math.ceil(d);
        }
        return false;
    }

    private static boolean isArray(Scriptable scriptable) {
        while (scriptable != null) {
            if (scriptable.getClassName().equals("Array")) {
                return true;
            }
            scriptable = scriptable.getPrototype();
        }
        return false;
    }

    public static final Object wrap(Parameter parameter, Object value, Scriptable scope, boolean doCopy) {
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            return Converter.wrap(parameter, (Map)value, scope, doCopy);
        }
        if (value instanceof List) {
            return Converter.wrap(parameter, (List)value, scope, doCopy);
        }
        if (value instanceof Function) {
            return Converter.wrap(parameter, (Function)value, scope, doCopy);
        }
        if (value instanceof JsonValue) {
            return Converter.wrap(parameter, (JsonValue)value, scope, doCopy);
        }
        if (value instanceof JsonPointer) {
            return Converter.wrap(parameter, value.toString(), scope, doCopy);
        }
        if (value instanceof Request) {
            return Converter.wrap(parameter, (Request)value, scope);
        }
        if (value instanceof Context) {
            return Converter.wrap(parameter, (Context)value, scope);
        }
        return org.mozilla.javascript.Context.javaToJS((Object)value, (Scriptable)scope);
    }

    public static final Object wrap(Parameter parameter, Map value, Scriptable scope, boolean doCopy) {
        if (doCopy) {
            ScriptableMap result = new ScriptableMap(Converter.getMap(parameter, value));
            ScriptRuntime.setBuiltinProtoAndParent((ScriptableObject)result, (Scriptable)scope, (TopLevel.Builtins)TopLevel.Builtins.Object);
            return result;
        }
        ScriptableMap result = new ScriptableMap(parameter, value);
        ScriptRuntime.setBuiltinProtoAndParent((ScriptableObject)result, (Scriptable)scope, (TopLevel.Builtins)TopLevel.Builtins.Object);
        return result;
    }

    public static final Object wrap(Parameter parameter, List value, Scriptable scope, boolean doCopy) {
        if (doCopy) {
            ScriptableList result = new ScriptableList(Converter.getList(parameter, value));
            ScriptRuntime.setBuiltinProtoAndParent((ScriptableObject)result, (Scriptable)scope, (TopLevel.Builtins)TopLevel.Builtins.Array);
            return result;
        }
        ScriptableList result = new ScriptableList(parameter, value);
        ScriptRuntime.setBuiltinProtoAndParent((ScriptableObject)result, (Scriptable)scope, (TopLevel.Builtins)TopLevel.Builtins.Array);
        return result;
    }

    public static final Object wrap(Parameter parameter, Function value, Scriptable scope, boolean doCopy) {
        ScriptableFunction result = new ScriptableFunction(parameter, value);
        ScriptRuntime.setBuiltinProtoAndParent((ScriptableObject)result, (Scriptable)scope, (TopLevel.Builtins)TopLevel.Builtins.Function);
        return result;
    }

    public static final Object wrap(Parameter parameter, JsonValue value, Scriptable scope, boolean doCopy) {
        if (value.isMap()) {
            return Converter.wrap(parameter, value.asMap(), scope, doCopy);
        }
        if (value.isList()) {
            return Converter.wrap(parameter, value.asList(), scope, doCopy);
        }
        return Converter.wrap(parameter, value.getObject(), scope, doCopy);
    }

    public static final Object wrap(Parameter parameter, Request value, Scriptable scope) {
        if (value instanceof CreateRequest) {
            ScriptableCreateRequest result = new ScriptableCreateRequest(parameter, (CreateRequest)value);
            ScriptRuntime.setBuiltinProtoAndParent((ScriptableObject)result, (Scriptable)scope, (TopLevel.Builtins)TopLevel.Builtins.Object);
            return result;
        }
        if (value instanceof DeleteRequest) {
            ScriptableDeleteRequest result = new ScriptableDeleteRequest(parameter, (DeleteRequest)value);
            ScriptRuntime.setBuiltinProtoAndParent((ScriptableObject)result, (Scriptable)scope, (TopLevel.Builtins)TopLevel.Builtins.Object);
            return result;
        }
        if (value instanceof PatchRequest) {
            ScriptablePatchRequest result = new ScriptablePatchRequest(parameter, (PatchRequest)value);
            ScriptRuntime.setBuiltinProtoAndParent((ScriptableObject)result, (Scriptable)scope, (TopLevel.Builtins)TopLevel.Builtins.Object);
            return result;
        }
        if (value instanceof QueryRequest) {
            ScriptableQueryRequest result = new ScriptableQueryRequest(parameter, (QueryRequest)value);
            ScriptRuntime.setBuiltinProtoAndParent((ScriptableObject)result, (Scriptable)scope, (TopLevel.Builtins)TopLevel.Builtins.Object);
            return result;
        }
        if (value instanceof ReadRequest) {
            ScriptableReadRequest result = new ScriptableReadRequest(parameter, (ReadRequest)value);
            ScriptRuntime.setBuiltinProtoAndParent((ScriptableObject)result, (Scriptable)scope, (TopLevel.Builtins)TopLevel.Builtins.Object);
            return result;
        }
        if (value instanceof UpdateRequest) {
            ScriptableUpdateRequest result = new ScriptableUpdateRequest(parameter, (UpdateRequest)value);
            ScriptRuntime.setBuiltinProtoAndParent((ScriptableObject)result, (Scriptable)scope, (TopLevel.Builtins)TopLevel.Builtins.Object);
            return result;
        }
        if (value instanceof ActionRequest) {
            ScriptableActionRequest result = new ScriptableActionRequest(parameter, (ActionRequest)value);
            ScriptRuntime.setBuiltinProtoAndParent((ScriptableObject)result, (Scriptable)scope, (TopLevel.Builtins)TopLevel.Builtins.Object);
            return result;
        }
        return org.mozilla.javascript.Context.javaToJS((Object)value, (Scriptable)scope);
    }

    public static final Object wrap(Parameter parameter, Context value, Scriptable scope) {
        ScriptableContext result = new ScriptableContext(parameter, value);
        ScriptRuntime.setBuiltinProtoAndParent((ScriptableObject)result, (Scriptable)scope, (TopLevel.Builtins)TopLevel.Builtins.Object);
        return result;
    }

    public static Object convert(Object value) {
        Object result = null;
        if (value == null || value == org.mozilla.javascript.Context.getUndefinedValue() || value == Scriptable.NOT_FOUND) {
            result = null;
        } else if (value instanceof Double || value instanceof Float) {
            Number number = (Number)value;
            result = Converter.isInteger(number) ? (Number)number.intValue() : (Number)number;
        } else if (value instanceof Scriptable) {
            Scriptable scriptable = (Scriptable)value;
            if (value instanceof NativeJavaObject) {
                return ((NativeJavaObject)value).unwrap();
            }
            if (value instanceof Wrapper) {
                result = Converter.convert(((Wrapper)value).unwrap());
            } else if (Converter.isArray(scriptable)) {
                Object o = scriptable.get("length", scriptable);
                if (o != null && o instanceof Number) {
                    int size = ((Number)o).intValue();
                    ArrayList<Object> list = new ArrayList<Object>(size);
                    for (int n = 0; n < size; ++n) {
                        list.add(Converter.convert(scriptable.get(n, scriptable)));
                    }
                    result = list;
                }
            } else {
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (Object id : scriptable.getIds()) {
                    String sid = id.toString();
                    Object object = id instanceof Number && Converter.isInteger((Number)id) ? scriptable.get(((Number)id).intValue(), scriptable) : scriptable.get(sid, scriptable);
                    map.put(sid, Converter.convert(object));
                }
                result = map;
            }
        } else if (value instanceof Number || value instanceof String || value instanceof Boolean || value instanceof Map || value instanceof List) {
            result = value;
        } else {
            if (value instanceof Request || value instanceof Context) {
                return value;
            }
            result = value instanceof CharSequence ? value.toString() : value;
        }
        return result;
    }

    public static AbstractFactory.MapFactory getMap(Parameter operationParameter, Map<String, Object> source) {
        return new CopyMapFactory(operationParameter, source);
    }

    public static AbstractFactory.ListFactory getList(Parameter operationParameter, List<Object> source) {
        return new CopyListFactory(operationParameter, source);
    }

    public static class CopyMapFactory
    extends AbstractFactory.MapFactory {
        private final Parameter parameter;

        public CopyMapFactory(Parameter parameter, Map<String, Object> source) {
            super(source);
            this.parameter = parameter;
        }

        public Parameter getParameter() {
            return this.parameter;
        }

        protected Factory<List<Object>> newListFactory(List<Object> source) {
            return Converter.getList(this.parameter, source);
        }

        protected Factory<Map<String, Object>> newMapFactory(Map<String, Object> source) {
            return Converter.getMap(this.parameter, source);
        }

        protected Object convertFunction(Function<?> source) {
            return source;
        }
    }

    public static class CopyListFactory
    extends AbstractFactory.ListFactory {
        private final Parameter parameter;

        public CopyListFactory(Parameter parameter, List<Object> source) {
            super(source);
            this.parameter = parameter;
        }

        public Parameter getParameter() {
            return this.parameter;
        }

        protected Factory<List<Object>> newListFactory(List<Object> source) {
            return Converter.getList(this.parameter, source);
        }

        protected Factory<Map<String, Object>> newMapFactory(Map<String, Object> source) {
            return Converter.getMap(this.parameter, source);
        }

        protected Object convertFunction(Function<?> source) {
            return source;
        }
    }
}

