/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.script.javascript;

import java.util.ArrayList;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.PatchOperation;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.Request;
import org.forgerock.script.javascript.AbstractScriptableRequest;
import org.forgerock.script.javascript.Converter;
import org.forgerock.script.scope.Parameter;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Wrapper;

class ScriptablePatchRequest
extends AbstractScriptableRequest
implements Wrapper {
    private static final long serialVersionUID = 1L;
    private final PatchRequest request;
    private static Object[] PROPERTIES = ScriptablePatchRequest.concatIds("patchOperations", "revision");

    public ScriptablePatchRequest(Parameter parameter, PatchRequest request) {
        super(parameter, (Request)request);
        this.request = request;
    }

    public String getClassName() {
        return "ScriptablePatchRequest";
    }

    @Override
    public Object get(String name, Scriptable start) {
        if ("patchOperations".equals(name)) {
            JsonValue value = new JsonValue(new ArrayList());
            for (PatchOperation operation : this.request.getPatchOperations()) {
                value.add(operation.toJsonValue().getObject());
            }
            return Converter.wrap(this.parameter, value, start, false);
        }
        if ("revision".equals(name)) {
            return Converter.wrap(this.parameter, this.request.getRevision(), start, false);
        }
        return super.get(name, start);
    }

    @Override
    public boolean has(String name, Scriptable start) {
        return "patchOperations".equals(name) || "revision".equals(name) || super.has(name, start);
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
    }

    @Override
    public void put(int index, Scriptable start, Object value) {
    }

    @Override
    public Object[] getIds() {
        return PROPERTIES;
    }
}

