/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.script.javascript;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.Request;
import org.forgerock.script.javascript.AbstractScriptableRequest;
import org.forgerock.script.javascript.Converter;
import org.forgerock.script.scope.Parameter;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Wrapper;

class ScriptableCreateRequest
extends AbstractScriptableRequest
implements Wrapper {
    private static final long serialVersionUID = 1L;
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    private final CreateRequest request;
    private static Object[] PROPERTIES = ScriptableCreateRequest.concatIds("content", "newResourceId");

    public ScriptableCreateRequest(Parameter parameter, CreateRequest request) {
        super(parameter, (Request)request);
        this.request = request;
    }

    public String getClassName() {
        return "ScriptableCreateRequest";
    }

    @Override
    public Object get(String name, Scriptable start) {
        if ("content".equals(name)) {
            return Converter.wrap(this.parameter, this.request.getContent(), start, false);
        }
        if ("newResourceId".equals(name)) {
            return Converter.wrap(this.parameter, this.request.getNewResourceId(), start, false);
        }
        return super.get(name, start);
    }

    @Override
    public boolean has(String name, Scriptable start) {
        return "content".equals(name) || "newResourceId".equals(name) || super.has(name, start);
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
        if ("content".equals(name)) {
            try {
                Object json = JSON_MAPPER.readValue((String)value, Object.class);
                if (json == null) {
                    this.request.setContent(new JsonValue(new LinkedHashMap(0)));
                } else if (json instanceof Map) {
                    this.request.setContent(new JsonValue(json));
                }
            }
            catch (IOException iOException) {}
        } else if ("newResourceId".equals(name)) {
            this.request.setNewResourceId((String)value);
        } else {
            super.put((Object)name, (Object)start);
        }
    }

    @Override
    public void put(int index, Scriptable start, Object value) {
    }

    @Override
    public Object[] getIds() {
        return PROPERTIES;
    }
}

