/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.script.javascript;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.forgerock.json.JsonValue;
import org.forgerock.script.javascript.Converter;
import org.forgerock.script.scope.Parameter;
import org.forgerock.services.context.ClientContext;
import org.forgerock.services.context.Context;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.annotations.JSFunction;

class ScriptableContext
extends NativeObject
implements Wrapper {
    private static final long serialVersionUID = 1L;
    private static final String CALLER = "caller";
    private static final String CURRENT = "current";
    private static final String PARENT = "parent";
    private static final String HTTP_CONTEXT_NAME = "http";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    final transient Parameter parameter;
    private final Map<String, Context> contexts;
    private final JsonValue caller;
    private final Set<String> ids;

    public ScriptableContext(Parameter parameter, Context context) {
        if (null == context) {
            throw new NullPointerException();
        }
        this.parameter = parameter;
        this.contexts = new HashMap<String, Context>();
        this.contexts.put(CURRENT, context);
        if (context.getParent() != null) {
            this.contexts.put(PARENT, context.getParent());
        }
        for (Context aContext = context; aContext != null; aContext = aContext.getParent()) {
            if (this.contexts.containsKey(aContext.getContextName())) continue;
            this.contexts.put(aContext.getContextName(), aContext);
        }
        this.ids = new HashSet<String>(this.contexts.keySet());
        if (context.containsContext(ClientContext.class)) {
            this.ids.add(CALLER);
            ClientContext client = (ClientContext)context.asContext(ClientContext.class);
            this.caller = JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"name", (Object)client.getContextName()), JsonValue.field((String)"external", (Object)client.isExternal())}));
        } else {
            this.caller = new JsonValue(null);
        }
    }

    Context getWrappedContext() {
        return this.contexts.get(CURRENT);
    }

    @JSFunction
    public boolean containsContext(Class clazz, Scriptable start) {
        return this.getWrappedContext().containsContext(clazz);
    }

    @JSFunction
    public Object asContext(Class clazz, Scriptable start) {
        return Converter.wrap(this.parameter, this.getWrappedContext().asContext(clazz).toJsonValue(), start, false);
    }

    @JSFunction
    public boolean containsContext(String contextName, Scriptable start) {
        return this.getWrappedContext().containsContext(contextName);
    }

    @JSFunction
    public Object getContext(String contextName, Scriptable start) {
        return Converter.wrap(this.parameter, this.getWrappedContext().getContext(contextName).toJsonValue(), start, false);
    }

    @JSFunction
    public Object getParent(Scriptable start) {
        return Converter.wrap(this.parameter, this.getWrappedContext().getParent(), start, false);
    }

    public Object get(String name, Scriptable start) {
        if (CALLER.equals(name)) {
            return Converter.wrap(this.parameter, this.caller, start, false);
        }
        if (this.contexts.containsKey(name)) {
            if (HTTP_CONTEXT_NAME.equals(name)) {
                JsonValue value = this.contexts.get(name).toJsonValue();
                value.put("headers", this.listValuesAsStrings(value.get("headers")));
                value.put("parameters", this.listValuesAsStrings(value.get("parameters")));
                return Converter.wrap(this.parameter, value, start, false);
            }
            return Converter.wrap(this.parameter, this.contexts.get(name).toJsonValue(), start, false);
        }
        return NOT_FOUND;
    }

    private Map<String, Object> listValuesAsStrings(JsonValue values) {
        TreeMap<String, Object> map = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        for (String key : values.keys()) {
            StringBuilder sb = new StringBuilder();
            for (Object value : values.get(key).asList()) {
                sb.append(value.toString());
                sb.append(",");
            }
            map.put(key, sb.substring(0, sb.length() - 1));
        }
        return map;
    }

    public Object get(int index, Scriptable start) {
        return NOT_FOUND;
    }

    public boolean has(String name, Scriptable start) {
        return this.ids.contains(name);
    }

    public boolean has(int index, Scriptable start) {
        return false;
    }

    public void put(String name, Scriptable start, Object value) {
    }

    public void put(int index, Scriptable start, Object value) {
    }

    public void delete(String name) {
    }

    public void delete(int index) {
    }

    public Object[] getIds() {
        return this.ids.toArray();
    }

    public boolean hasInstance(Scriptable instance) {
        return false;
    }

    public Object unwrap() {
        return this.getWrappedContext();
    }

    public String toString() {
        JsonValue allContexts = new JsonValue(new HashMap(this.contexts.size()));
        for (Map.Entry<String, Context> entry : this.contexts.entrySet()) {
            allContexts.put(entry.getKey(), entry.getValue().toJsonValue().getObject());
        }
        return allContexts.toString();
    }

    public Object getDefaultValue(Class<?> hint) {
        if (hint == null || hint == String.class) {
            return this.toString();
        }
        return super.getDefaultValue(hint);
    }
}

