/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.script.javascript;

import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLF4JErrorReporter
implements ErrorReporter {
    private static final Logger logger = LoggerFactory.getLogger(SLF4JErrorReporter.class);
    private final ErrorReporter chainedReporter;

    public static ErrorReporter chain(ErrorReporter chainedReporter) {
        return new SLF4JErrorReporter(chainedReporter);
    }

    public SLF4JErrorReporter(ErrorReporter chainedReporter) {
        this.chainedReporter = chainedReporter;
    }

    public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
        logger.warn("", new Object[]{message, sourceName, line, lineSource, lineOffset});
        if (this.chainedReporter != null) {
            this.chainedReporter.warning(message, sourceName, line, lineSource, lineOffset);
        }
    }

    public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
        logger.error("", new Object[]{message, sourceName, line, lineSource, lineOffset});
        if (this.chainedReporter == null) {
            throw this.runtimeError(message, sourceName, line, lineSource, lineOffset);
        }
        this.chainedReporter.error(message, sourceName, line, lineSource, lineOffset);
    }

    public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
        if (this.chainedReporter != null) {
            return this.chainedReporter.runtimeError(message, sourceName, line, sourceName, lineOffset);
        }
        return new EvaluatorException(message, sourceName, line, sourceName, lineOffset);
    }
}

