/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.script.javascript;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.forgerock.script.engine.ScriptEngine;
import org.forgerock.script.engine.ScriptEngineFactory;
import org.forgerock.script.javascript.RhinoScriptEngine;
import org.forgerock.script.source.SourceContainer;

public class RhinoScriptEngineFactory
implements ScriptEngineFactory {
    public static final String VERSION = "1.7 release 4";
    public static final String LANGUAGE_NAME = "ECMAScript";
    private static List<String> names = new ArrayList<String>(6);
    private static List<String> mimeTypes;
    private static List<String> extensions;
    private RhinoScriptEngine engine = null;

    public String getEngineName() {
        return "javascript";
    }

    public String getEngineVersion() {
        return VERSION;
    }

    public List<String> getExtensions() {
        return extensions;
    }

    public List<String> getMimeTypes() {
        return mimeTypes;
    }

    public List<String> getNames() {
        return names;
    }

    public String getLanguageName() {
        return LANGUAGE_NAME;
    }

    public String getLanguageVersion() {
        return "1.8";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptEngine getScriptEngine(Map<String, Object> configuration, Collection<SourceContainer> sourceContainers, ClassLoader registryLevelClassLoader) {
        if (null == this.engine) {
            RhinoScriptEngineFactory rhinoScriptEngineFactory = this;
            synchronized (rhinoScriptEngineFactory) {
                if (null == this.engine) {
                    this.engine = new RhinoScriptEngine(configuration, this, sourceContainers, registryLevelClassLoader);
                }
            }
        }
        return this.engine;
    }

    static {
        names.add("js");
        names.add("rhino");
        names.add("JavaScript");
        names.add("javascript");
        names.add(LANGUAGE_NAME);
        names.add("ecmascript");
        names = Collections.unmodifiableList(names);
        mimeTypes = new ArrayList<String>(4);
        mimeTypes.add("application/javascript");
        mimeTypes.add("application/ecmascript");
        mimeTypes.add("text/javascript");
        mimeTypes.add("text/ecmascript");
        mimeTypes = Collections.unmodifiableList(mimeTypes);
        extensions = new ArrayList<String>(1);
        extensions.add("js");
        extensions = Collections.unmodifiableList(extensions);
    }
}

