/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.script.javascript;

import java.util.Arrays;
import java.util.HashMap;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.Request;
import org.forgerock.script.javascript.Converter;
import org.forgerock.script.scope.Parameter;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Wrapper;

abstract class AbstractScriptableRequest
extends NativeObject
implements Wrapper {
    private static final long serialVersionUID = 1L;
    private static final String FIELD_METHOD = "method";
    final transient Parameter parameter;
    private final Request request;
    private static final Object[] PROPERTIES = new Object[]{"method", "fields", "resourcePath", "additionalParameters"};

    public AbstractScriptableRequest(Parameter parameter, Request request) {
        if (null == request) {
            throw new NullPointerException();
        }
        this.parameter = parameter;
        this.request = request;
    }

    public Object get(String name, Scriptable start) {
        if (FIELD_METHOD.equals(name)) {
            return Converter.wrap(this.parameter, this.request.getRequestType().toString().toLowerCase(), start, false);
        }
        if ("fields".equals(name)) {
            return Converter.wrap(this.parameter, this.request.getFields(), start, false);
        }
        if ("resourcePath".equals(name)) {
            return Converter.wrap(this.parameter, this.request.getResourcePath(), start, false);
        }
        if ("additionalParameters".equals(name)) {
            return Converter.wrap(this.parameter, this.request.getAdditionalParameters(), start, false);
        }
        return NOT_FOUND;
    }

    public Object get(int index, Scriptable start) {
        return NOT_FOUND;
    }

    public boolean has(String name, Scriptable start) {
        return FIELD_METHOD.equals(name) || "fields".equals(name) || "resourcePath".equals(name) || "additionalParameters".equals(name);
    }

    public boolean has(int index, Scriptable start) {
        return false;
    }

    public void put(String name, Scriptable start, Object value) {
    }

    public void put(int index, Scriptable start, Object value) {
    }

    public void delete(String name) {
    }

    public void delete(int index) {
    }

    public Object[] getIds() {
        return PROPERTIES;
    }

    protected static Object[] concatIds(Object ... properties) {
        Object[] result = Arrays.copyOf(PROPERTIES, PROPERTIES.length + properties.length);
        System.arraycopy(properties, 0, result, PROPERTIES.length, properties.length);
        return result;
    }

    public boolean hasInstance(Scriptable instance) {
        return false;
    }

    public Object unwrap() {
        return this.request;
    }

    public String toString() {
        if (this.request == null) {
            return "null";
        }
        JsonValue value = new JsonValue(new HashMap());
        for (Object id : this.getIds()) {
            value.put((String)id, this.get((String)id, (Scriptable)this));
        }
        return value.toString();
    }

    public Object getDefaultValue(Class<?> hint) {
        if (hint == null || hint == String.class) {
            return this.toString();
        }
        return super.getDefaultValue(hint);
    }
}

