/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.util;

public final class Option<T> {
    private final T defaultValue;
    private final Class<T> type;

    public static <T> Option<T> of(Class<T> type, T defaultValue) {
        return new Option<T>(type, defaultValue);
    }

    public static <T> Option<T> withDefault(T defaultValue) {
        return new Option(defaultValue.getClass(), defaultValue);
    }

    private Option(Class<T> type, T defaultValue) {
        this.type = type;
        this.defaultValue = defaultValue;
    }

    T getValue(Object value) {
        return value != null ? this.type.cast(value) : this.defaultValue;
    }
}

