/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.util;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class RangeSet
extends AbstractSet<Integer>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int start;
    private final int stop;
    private final int step;

    public RangeSet(int stop) {
        this(0, stop, 1);
    }

    public RangeSet(int start, int stop) {
        this(start, stop, 1);
    }

    public RangeSet(int start, int stop, int step) {
        if (step == 0) {
            throw new IllegalArgumentException();
        }
        this.start = start;
        this.stop = stop;
        this.step = step;
    }

    @Override
    public int size() {
        int difference = this.stop - this.start;
        int count = difference / this.step;
        int remainder = Math.abs(difference % this.step);
        return count > 0 ? count + remainder : 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        boolean result = false;
        if (o != null && o instanceof Integer && this.size() != 0) {
            int contains = ((Number)o).intValue();
            if (this.step > 0 && contains >= this.start && contains < this.stop || this.step < 0 && contains >= this.start && contains > this.stop) {
                result = (contains - this.start) % this.step == 0;
            }
        }
        return result;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            int cursor;
            {
                this.cursor = RangeSet.this.start;
            }

            @Override
            public boolean hasNext() {
                boolean result = RangeSet.this.step > 0 ? this.cursor < RangeSet.this.stop : this.cursor > RangeSet.this.stop;
                return result;
            }

            @Override
            public Integer next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                int result = this.cursor;
                this.cursor += RangeSet.this.step;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

