/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.schema;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Console;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.forgerock.json.JsonValue;
import org.forgerock.json.schema.validator.ErrorHandler;
import org.forgerock.json.schema.validator.FailFastErrorHandler;
import org.forgerock.json.schema.validator.ObjectValidatorFactory;
import org.forgerock.json.schema.validator.exceptions.SchemaException;
import org.forgerock.json.schema.validator.exceptions.ValidationException;
import org.forgerock.json.schema.validator.validators.Validator;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.ExampleMode;
import org.kohsuke.args4j.Option;

public final class Main {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String ROOT_SCHEMA_ID = "http://www.forgerock.org/schema/";
    private final Map<URI, Validator> schemaCache = new HashMap<URI, Validator>();
    @Option(name="-v", aliases={"--verbose"}, usage="display all validation error not just the first")
    private boolean verbose;
    @Option(name="-s", aliases={"--schemas"}, required=true, usage="file or folder contains the schema(s)", metaVar="./schema")
    private File schemaFile = new File("./schema");
    @Option(name="-b", aliases={"--base"}, metaVar="http://www.forgerock.org/schema/", usage="base value to resolve relative schema IDs. Default: http://www.forgerock.org/schema/")
    private String schemeBase = "http://www.forgerock.org/schema/";
    @Option(name="-i", aliases={"--id"}, usage="id of the schema. Optional if the object has \"$schema\" property")
    private String schemaURI;
    @Option(name="-f", aliases={"--file"}, usage="input from this file", metaVar="sample.json")
    private File inputFile;
    @Argument
    private List<String> arguments = new ArrayList<String>();

    public static void main(String[] args) throws Exception {
        new Main().doMain(args);
    }

    private void doMain(String[] args) throws Exception {
        CmdLineParser parser = new CmdLineParser(this);
        parser.setUsageWidth(80);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println("java Main [options...] arguments...");
            parser.printUsage(System.err);
            System.err.println();
            System.err.println("  Example: java Main" + parser.printExample(ExampleMode.REQUIRED));
            System.err.println("  Example: java Main" + parser.printExample(ExampleMode.ALL));
            return;
        }
        URI base = new URI(this.schemeBase);
        if (!base.isAbsolute()) {
            throw new IllegalArgumentException("-b (-base) must be an absolute URI");
        }
        this.init(base);
        if (null == this.inputFile) {
            while (true) {
                try {
                    while (true) {
                        this.validate(this.loadFromConsole());
                    }
                }
                catch (Exception e) {
                    this.printOutException(e);
                    continue;
                }
                break;
            }
        }
        try {
            this.validate(this.loadFromFile());
        }
        catch (Exception e) {
            this.printOutException(e);
        }
    }

    private void init(URI base) throws IOException {
        System.out.append("Loading schemas from: ").append(this.schemaFile.getAbsolutePath()).append(" with base ").append(base.toString()).println(" URI");
        if (this.schemaFile.isDirectory()) {
            this.validateDirectory(this.schemaFile);
            FileFilter filter = new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().endsWith(".json");
                }
            };
            for (File f : this.getFileListingNoSort(this.schemaFile, filter)) {
                URI relative = this.schemaFile.toURI().relativize(f.toURI());
                this.loadSchema(base.resolve(relative), f);
            }
        } else if (this.schemaFile.isFile()) {
            this.loadSchema(base, this.schemaFile);
        } else {
            System.exit(1);
        }
    }

    private void loadSchema(URI base, File schemaFile) throws IOException {
        JsonValue schemaMap = new JsonValue(MAPPER.readValue((InputStream)new FileInputStream(schemaFile), Map.class));
        URI id = schemaMap.get("id").required().asURI();
        Validator v = ObjectValidatorFactory.getTypeValidator(schemaMap.asMap());
        if (!id.isAbsolute()) {
            id = base.resolve(id);
        }
        this.schemaCache.put(id, v);
        System.out.append("Schema ").append(id.toString()).println(" loaded from file:");
        System.out.append("     location: ").println(schemaFile.getAbsolutePath());
    }

    private List<File> getFileListingNoSort(File aStartingDir, FileFilter filter) throws FileNotFoundException {
        ArrayList<File> result = new ArrayList<File>();
        List<File> filesDirs = Arrays.asList(aStartingDir.listFiles(filter));
        for (File file : filesDirs) {
            if (!file.isFile()) {
                List<File> deeperList = this.getFileListingNoSort(file, filter);
                result.addAll(deeperList);
                continue;
            }
            result.add(file);
        }
        return result;
    }

    private void validateDirectory(File aDirectory) throws FileNotFoundException {
        if (aDirectory == null) {
            throw new IllegalArgumentException("Directory should not be null.");
        }
        if (!aDirectory.exists()) {
            throw new FileNotFoundException("Directory does not exist: " + aDirectory);
        }
        if (!aDirectory.isDirectory()) {
            throw new IllegalArgumentException("Is not a directory: " + aDirectory);
        }
        if (!aDirectory.canRead()) {
            throw new IllegalArgumentException("Directory cannot be read: " + aDirectory);
        }
    }

    private void validate(JsonValue value) throws SchemaException, URISyntaxException {
        Validator validator;
        URI schemaId = value.get("$schema").asURI();
        if (null == schemaId && Main.isEmptyOrBlank(this.schemaURI)) {
            System.out.println("-i (--id) must be an URI");
            return;
        }
        if (null == schemaId) {
            schemaId = new URI(this.schemaURI);
        }
        if (null != (validator = this.schemaCache.get(schemaId))) {
            if (this.verbose) {
                final boolean[] valid = new boolean[1];
                validator.validate(value.getObject(), null, new ErrorHandler(){

                    @Override
                    public void error(ValidationException exception) throws SchemaException {
                        valid[0] = false;
                        Main.this.printOutException(exception);
                    }

                    @Override
                    @Deprecated
                    public void assembleException() throws ValidationException {
                    }
                });
                if (valid.length == 0) {
                    System.out.println("OK - Object is valid!");
                }
            } else {
                validator.validate(value.getObject(), null, new FailFastErrorHandler());
                System.out.println("OK - Object is valid!");
            }
        } else {
            System.out.append("Schema ").append(schemaId.toString()).println(" not found!");
        }
    }

    private JsonValue loadFromConsole() throws IOException {
        System.out.println();
        System.out.println("> Enter 'exit' and press enter to exit");
        System.out.println("> Press ctrl-D to finish input");
        System.out.println("Start data input:");
        String input = null;
        StringBuilder stringBuilder = new StringBuilder();
        Console c = System.console();
        if (c == null) {
            System.err.println("No console.");
            System.exit(1);
        }
        Scanner scanner = new Scanner(c.reader());
        while (scanner.hasNext() && null != (input = scanner.next())) {
            if ("exit".equalsIgnoreCase(input)) {
                System.exit(0);
                continue;
            }
            stringBuilder.append(input);
        }
        return new JsonValue(MAPPER.readValue(stringBuilder.toString(), Object.class));
    }

    private JsonValue loadFromFile() throws IOException {
        return new JsonValue(MAPPER.readValue(this.inputFile, Object.class));
    }

    private static boolean isEmptyOrBlank(String str) {
        return str == null || str.trim().isEmpty();
    }

    private void printOutException(Exception ex) {
        String top = "> > > > > >                                                         < < < < < <";
        String exName = ex.getClass().getSimpleName();
        StringBuilder sb = new StringBuilder(top.substring(0, 40 - exName.length() / 2)).append(exName);
        sb.append(top.substring(sb.length()));
        System.out.println(sb);
        if (ex instanceof SchemaException && null != ((SchemaException)ex).getJsonValue()) {
            System.out.append("Path: ").println(((SchemaException)ex).getJsonValue().getPointer().toString());
        }
        System.out.append("Message: ").println(ex.getMessage());
        System.out.println("- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -");
    }

    private Main() {
    }
}

