/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json;

import java.util.List;
import java.util.Map;
import org.forgerock.json.JsonValue;
import org.forgerock.json.JsonValueException;
import org.forgerock.util.Function;

public class JsonValueTraverseFunction
implements Function<JsonValue, JsonValue, JsonValueException> {
    private Function<JsonValue, ?, JsonValueException> transform;

    public JsonValueTraverseFunction(Function<JsonValue, ?, JsonValueException> transform) {
        this.transform = transform;
    }

    @Override
    public final JsonValue apply(JsonValue value) {
        return new JsonValue(this.traverse(value), value.getPointer());
    }

    private Object traverse(JsonValue value) {
        if (value.isList()) {
            return this.traverseList(value);
        }
        if (value.isMap()) {
            return this.traverseMap(value);
        }
        return value.as(this.transform);
    }

    protected Object traverseList(JsonValue value) {
        List<Object> result = JsonValue.array(new Object[0]);
        for (JsonValue elem : value) {
            result.add(this.apply(elem).getObject());
        }
        return result;
    }

    protected Object traverseMap(JsonValue value) {
        Map<String, Object> result = JsonValue.object(value.size());
        for (String key : value.keys()) {
            result.put(key, this.apply(value.get(key)).getObject());
        }
        return result;
    }
}

