/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.util.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.forgerock.util.query.QueryFilter;
import org.forgerock.util.query.QueryFilterVisitor;

public class MapFilterVisitor<F>
implements QueryFilterVisitor<Map<String, Object>, Void, F> {
    static final String OPERATOR = "operator";
    static final String FIELD = "field";
    static final String VALUE = "value";
    static final String SUBFILTERS = "subfilters";
    static final String SUBFILTER = "subfilter";

    @Override
    public Map<String, Object> visitAndFilter(Void parameters, List<QueryFilter<F>> subFilters) {
        ArrayList filters = new ArrayList();
        for (QueryFilter<F> filter : subFilters) {
            filters.add(filter.accept(this, parameters));
        }
        HashMap<String, Object> object = new HashMap<String, Object>();
        object.put(OPERATOR, "and");
        object.put(SUBFILTERS, filters);
        return object;
    }

    @Override
    public Map<String, Object> visitBooleanLiteralFilter(Void parameters, boolean value) {
        HashMap<String, Object> object = new HashMap<String, Object>();
        object.put(OPERATOR, value);
        return object;
    }

    @Override
    public Map<String, Object> visitContainsFilter(Void parameters, F field, Object valueAssertion) {
        return this.object(field, "co", valueAssertion);
    }

    @Override
    public Map<String, Object> visitEqualsFilter(Void parameters, F field, Object valueAssertion) {
        return this.object(field, "eq", valueAssertion);
    }

    @Override
    public Map<String, Object> visitExtendedMatchFilter(Void parameters, F field, String operator, Object valueAssertion) {
        return this.object(field, operator, valueAssertion);
    }

    @Override
    public Map<String, Object> visitGreaterThanFilter(Void parameters, F field, Object valueAssertion) {
        return this.object(field, "gt", valueAssertion);
    }

    @Override
    public Map<String, Object> visitGreaterThanOrEqualToFilter(Void parameters, F field, Object valueAssertion) {
        return this.object(field, "ge", valueAssertion);
    }

    @Override
    public Map<String, Object> visitLessThanFilter(Void parameters, F field, Object valueAssertion) {
        return this.object(field, "lt", valueAssertion);
    }

    @Override
    public Map<String, Object> visitLessThanOrEqualToFilter(Void parameters, F field, Object valueAssertion) {
        return this.object(field, "le", valueAssertion);
    }

    @Override
    public Map<String, Object> visitNotFilter(Void parameters, QueryFilter<F> subFilter) {
        HashMap<String, Object> object = new HashMap<String, Object>();
        object.put(OPERATOR, "!");
        object.put(SUBFILTER, subFilter.accept(this, parameters));
        return object;
    }

    @Override
    public Map<String, Object> visitOrFilter(Void parameters, List<QueryFilter<F>> subFilters) {
        ArrayList filters = new ArrayList();
        for (QueryFilter<F> filter : subFilters) {
            filters.add(filter.accept(this, parameters));
        }
        HashMap<String, Object> object = new HashMap<String, Object>();
        object.put(OPERATOR, "or");
        object.put(SUBFILTERS, filters);
        return object;
    }

    @Override
    public Map<String, Object> visitPresentFilter(Void parameters, F field) {
        HashMap<String, Object> object = new HashMap<String, Object>();
        object.put(OPERATOR, "pr");
        object.put(FIELD, field.toString());
        return object;
    }

    @Override
    public Map<String, Object> visitStartsWithFilter(Void parameters, F field, Object valueAssertion) {
        return this.object(field, "sw", valueAssertion);
    }

    private Map<String, Object> object(F field, String operator, Object valueAssertion) {
        HashMap<String, Object> object = new HashMap<String, Object>();
        object.put(OPERATOR, operator);
        object.put(FIELD, field.toString());
        if (valueAssertion == null || valueAssertion instanceof Number || valueAssertion instanceof Boolean) {
            object.put(VALUE, valueAssertion);
        } else {
            object.put(VALUE, String.valueOf(valueAssertion));
        }
        return object;
    }
}

