/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.crypto.cli;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.forgerock.json.JsonValue;
import org.forgerock.json.crypto.JsonCrypto;
import org.forgerock.json.crypto.JsonCryptoException;
import org.forgerock.json.crypto.JsonCryptoTransformer;
import org.forgerock.json.crypto.simple.SimpleDecryptor;
import org.forgerock.json.crypto.simple.SimpleEncryptor;
import org.forgerock.json.crypto.simple.SimpleKeyStoreSelector;
import org.forgerock.security.keystore.KeyStoreBuilder;
import org.forgerock.security.keystore.KeyStoreType;
import org.forgerock.util.Utils;

public class Main {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final Options OPTIONS = new Options();
    private static final String PROPERTIES_ALIAS_OPTION = "alias";
    private static final String PROPERTIES_CIPHER_OPTION = "cipher";
    private static final String DEFAULT_CIPHER = "AES/CBC/PKCS5Padding";
    private static final String PROPERTIES_SRCJSON_OPTION = "srcjson";
    private static final String PROPERTIES_DESTJSON_OPTION = "destjson";
    private static final String PROPERTIES_KEYPASS_OPTION = "keypass";
    private static final String PROPERTIES_KEYSTORE_OPTION = "keystore";
    private static final String PROPERTIES_STOREPASS_OPTION = "storepass";
    private static final String PROPERTIES_STORETYPE_OPTION = "storetype";
    private static final String PROPERTIES_PROVIDERNAME_OPTION = "providername";
    private static final String PROPERTIES_PROVIDERCLASS_OPTION = "providerclass";
    private static final String PROPERTIES_PROVIDERARG_OPTION = "providerarg";
    private static final String PROPERTIES_PROVIDERPATH_OPTION = "providerpath";
    private static final String PROPERTIES_ENCRYPT_COMMAND = "encrypt";
    private static final String PROPERTIES_DECRYPT_COMMAND = "decrypt";
    private static final String PROPERTIES_HELP_COMMAND = "help";
    private CommandLine cmd = null;

    public static void main(String[] args) throws Exception {
        Main cliProg = new Main();
        cliProg.loadArgs(args);
        cliProg.exec();
    }

    public void exec() throws Exception {
        if (this.cmd.hasOption(PROPERTIES_ENCRYPT_COMMAND)) {
            Key key = this.getSimpleKeySelector(this.cmd.getOptionValue(PROPERTIES_KEYSTORE_OPTION), this.cmd.getOptionValue(PROPERTIES_STORETYPE_OPTION, KeyStore.getDefaultType()), this.cmd.getOptionValue(PROPERTIES_STOREPASS_OPTION), this.cmd.getOptionValue(PROPERTIES_PROVIDERNAME_OPTION)).select(this.cmd.getOptionValue(PROPERTIES_ALIAS_OPTION));
            if (key == null) {
                throw new JsonCryptoException("key not found: " + this.cmd.getOptionValue(PROPERTIES_ALIAS_OPTION));
            }
            SimpleEncryptor encryptor = new SimpleEncryptor(this.cmd.getOptionValue(PROPERTIES_CIPHER_OPTION, DEFAULT_CIPHER), key, this.cmd.getOptionValue(PROPERTIES_ALIAS_OPTION));
            JsonValue value = this.getSourceValue(this.cmd.getOptionValue(PROPERTIES_SRCJSON_OPTION), true);
            value = new JsonCrypto(encryptor.getType(), encryptor.encrypt(value)).toJsonValue();
            this.setDestinationValue(this.cmd.getOptionValue(PROPERTIES_DESTJSON_OPTION), value);
        } else if (this.cmd.hasOption(PROPERTIES_DECRYPT_COMMAND)) {
            ArrayList<JsonCryptoTransformer> decryptionTransformers = new ArrayList<JsonCryptoTransformer>(1);
            decryptionTransformers.add(new JsonCryptoTransformer(new SimpleDecryptor(this.getSimpleKeySelector(this.cmd.getOptionValue(PROPERTIES_KEYSTORE_OPTION), this.cmd.getOptionValue(PROPERTIES_STORETYPE_OPTION, KeyStore.getDefaultType()), this.cmd.getOptionValue(PROPERTIES_STOREPASS_OPTION), this.cmd.getOptionValue(PROPERTIES_PROVIDERNAME_OPTION)))));
            JsonValue value = this.getSourceValue(this.cmd.getOptionValue(PROPERTIES_SRCJSON_OPTION), true);
            ((JsonCryptoTransformer)decryptionTransformers.get(0)).transform(value);
            this.setDestinationValue(this.cmd.getOptionValue(PROPERTIES_DESTJSON_OPTION), value);
        } else {
            Main.usage();
        }
    }

    private SimpleKeyStoreSelector getSimpleKeySelector(String keystore, String type, String password, String provider) throws Exception {
        KeyStore ks = new KeyStoreBuilder().withKeyStoreFile(keystore).withPassword(password).withProvider(provider).withKeyStoreType(Utils.asEnum(type, KeyStoreType.class)).build();
        return new SimpleKeyStoreSelector(ks, password);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JsonValue getSourceValue(String source, boolean file) throws IOException {
        JsonValue src = null;
        if (!file) return new JsonValue(MAPPER.readValue(source, Object.class));
        File srcFile = new File(source);
        if (!srcFile.exists()) throw new FileNotFoundException("JsonSource file not found at: " + srcFile.getAbsolutePath());
        return new JsonValue(MAPPER.readValue(srcFile, Object.class));
    }

    private void setDestinationValue(String destination, JsonValue value) throws IOException {
        if (null == destination) {
            MAPPER.writeValue(System.out, value.getObject());
        } else {
            File dest = new File(destination);
            dest.getParentFile().mkdirs();
            MAPPER.writeValue(dest, value.getObject());
        }
    }

    private void loadArgs(String[] args) {
        PosixParser parser = new PosixParser();
        try {
            this.cmd = parser.parse(OPTIONS, args);
        }
        catch (ParseException e) {
            System.err.println("Error parsing arguments");
            e.printStackTrace();
            System.exit(1);
        }
        if (this.cmd.hasOption('h')) {
            Main.usage();
            System.exit(0);
        }
        if (this.cmd.hasOption(PROPERTIES_HELP_COMMAND)) {
            Main.usage();
            System.exit(0);
        }
    }

    private static void usage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java -jar json-crypto-1.0.0-command-line.jar", OPTIONS);
    }

    static {
        OPTIONS.addOption(PROPERTIES_ENCRYPT_COMMAND, false, "Encrypt input file");
        OPTIONS.addOption(PROPERTIES_DECRYPT_COMMAND, false, "Decrypt input file");
        OPTIONS.addOption("h", PROPERTIES_HELP_COMMAND, false, "Display help");
        OPTIONS.addOption(PROPERTIES_ALIAS_OPTION, true, "Cryptography key alias.");
        OPTIONS.addOption(PROPERTIES_CIPHER_OPTION, true, "Cipher algorithm. AES/CBC/PKCS5Padding by default");
        OPTIONS.addOption(PROPERTIES_SRCJSON_OPTION, true, "Input JSON File");
        OPTIONS.addOption(PROPERTIES_DESTJSON_OPTION, true, "Output JSON File");
        OPTIONS.addOption(PROPERTIES_KEYSTORE_OPTION, true, "KeyStore File");
        OPTIONS.addOption(PROPERTIES_STOREPASS_OPTION, true, "KeyStore password.");
        OPTIONS.addOption(PROPERTIES_STORETYPE_OPTION, true, "KeyStore type. Default: " + KeyStore.getDefaultType());
        OPTIONS.addOption(PROPERTIES_KEYPASS_OPTION, true, "Key password");
        OPTIONS.addOption(PROPERTIES_PROVIDERNAME_OPTION, true, "KeyStore provider");
        OPTIONS.addOption(PROPERTIES_PROVIDERCLASS_OPTION, true, "KeyStore provider class");
        OPTIONS.addOption(PROPERTIES_PROVIDERARG_OPTION, true, "KeyStore provider options");
        OPTIONS.addOption(PROPERTIES_PROVIDERPATH_OPTION, true, "KeyStore provider path");
    }
}

