/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.i18n.maven;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.forgerock.i18n.maven.MessagePropertyKey;

public final class CleanMessagesMojo
extends AbstractMojo {
    private File sourceDirectory;
    private File messageFile;
    private String encoding;
    private final Map<MessagePropertyKey, String> unreferencedProperties = new ConcurrentHashMap<MessagePropertyKey, String>();
    private final Map<MessagePropertyKey, String> referencedProperties = new ConcurrentHashMap<MessagePropertyKey, String>();
    private final AtomicInteger fileCount = new AtomicInteger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        Closeable propertiesFile;
        if (!this.sourceDirectory.exists()) {
            throw new MojoExecutionException("Source directory " + this.sourceDirectory.getPath() + " does not exist");
        }
        if (!this.sourceDirectory.isDirectory()) {
            throw new MojoExecutionException("Source directory " + this.sourceDirectory.getPath() + " is not a directory");
        }
        if (!this.messageFile.exists()) {
            throw new MojoExecutionException("Message file " + this.messageFile.getPath() + " does not exist");
        }
        if (!this.messageFile.isFile()) {
            throw new MojoExecutionException("Message file " + this.messageFile.getPath() + " is not a file");
        }
        Properties properties = new Properties();
        try {
            FileInputStream propertiesFile2 = new FileInputStream(this.messageFile);
            try {
                properties.load(propertiesFile2);
            }
            finally {
                try {
                    propertiesFile2.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("An IO error occurred while reading the message property file: " + e);
        }
        for (Map.Entry<Object, Object> property : properties.entrySet()) {
            String propKey = property.getKey().toString();
            MessagePropertyKey key = MessagePropertyKey.valueOf(propKey);
            this.unreferencedProperties.put(key, property.getValue().toString());
        }
        int messageCount = this.unreferencedProperties.size();
        ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2);
        this.processSourceDirectory(executor, this.sourceDirectory);
        executor.shutdown();
        try {
            executor.awaitTermination(1L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MojoExecutionException("Interrupted while processing source files");
        }
        if (this.unreferencedProperties.size() + this.referencedProperties.size() != messageCount) {
            throw new IllegalStateException("Message table sizes are invalid");
        }
        this.getLog().info((CharSequence)("Processed " + this.fileCount.get() + " source files"));
        this.getLog().info((CharSequence)("Found " + this.unreferencedProperties.size() + " / " + messageCount + " unreferenced properties"));
        int cleanedMessageCount = 0;
        int savedMessageCount = 0;
        ArrayList<String> lines = new ArrayList<String>(10000);
        try {
            propertiesFile = new FileInputStream(this.messageFile);
            try {
                String line;
                LineNumberReader reader = new LineNumberReader(new InputStreamReader((InputStream)propertiesFile, "ISO-8859-1"));
                boolean inValue = false;
                boolean lineNeedsRemoving = false;
                boolean foundErrors = false;
                while ((line = reader.readLine()) != null) {
                    if (!inValue) {
                        MessagePropertyKey mpk;
                        String trimmedLine = line.trim();
                        if (trimmedLine.length() == 0) {
                            lines.add(line);
                            continue;
                        }
                        if (trimmedLine.startsWith("#")) {
                            lines.add(line);
                            continue;
                        }
                        int separator = trimmedLine.indexOf(61);
                        String key = separator < 0 ? trimmedLine : trimmedLine.substring(0, separator).trim();
                        try {
                            mpk = MessagePropertyKey.valueOf(key);
                        }
                        catch (IllegalArgumentException e) {
                            this.getLog().error((CharSequence)("Unable to decode line " + reader.getLineNumber() + ": " + line), (Throwable)e);
                            lines.add(line);
                            lineNeedsRemoving = false;
                            inValue = this.isContinuedOnNextLine(line);
                            foundErrors = true;
                            continue;
                        }
                        if (this.referencedProperties.containsKey(mpk)) {
                            ++savedMessageCount;
                            lines.add(line);
                            lineNeedsRemoving = false;
                        } else {
                            if (!this.unreferencedProperties.containsKey(mpk)) {
                                throw new IllegalStateException("Unregistered message key");
                            }
                            ++cleanedMessageCount;
                            lineNeedsRemoving = true;
                        }
                        inValue = this.isContinuedOnNextLine(line);
                        continue;
                    }
                    if (!lineNeedsRemoving) {
                        lines.add(line);
                    }
                    inValue = this.isContinuedOnNextLine(line);
                }
                if (foundErrors) {
                    throw new MojoExecutionException("Aborting because the message file could not be parsed");
                }
            }
            finally {
                try {
                    ((FileInputStream)propertiesFile).close();
                }
                catch (Exception reader) {}
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("An IO error occurred while reading the message property file: " + e);
        }
        if (cleanedMessageCount == 0) {
            this.getLog().info((CharSequence)("Message file " + this.messageFile.getName() + " unchanged: no messages were cleaned"));
        } else {
            try {
                propertiesFile = new FileOutputStream(this.messageFile);
                try {
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)propertiesFile, "ISO-8859-1");
                    String eol = System.getProperty("line.separator");
                    for (String line : lines) {
                        writer.write(line);
                        writer.write(eol);
                    }
                    writer.close();
                }
                finally {
                    try {
                        ((FileOutputStream)propertiesFile).close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("An IO error occurred while writing the message property file: " + e);
            }
            this.getLog().info((CharSequence)("Message file " + this.messageFile.getName() + " cleaned: " + cleanedMessageCount + " messages removed and " + savedMessageCount + " kept"));
        }
    }

    boolean isContinuedOnNextLine(String line) {
        int bsCount = 0;
        for (int i = line.length() - 1; i >= 0 && line.charAt(i) == '\\'; --i) {
            ++bsCount;
        }
        return bsCount % 2 == 1;
    }

    private void processSourceDirectory(ExecutorService executor, File s) {
        for (File f : s.listFiles()) {
            if (f.isDirectory()) {
                this.processSourceDirectory(executor, f);
                continue;
            }
            if (!f.isFile() || !f.getName().endsWith(".java")) continue;
            executor.execute(new SourceFileTask(f));
        }
    }

    private final class SourceFileTask
    implements Runnable {
        private final File sourceFile;

        private SourceFileTask(File sourceFile) {
            this.sourceFile = sourceFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LinkedList keys = new LinkedList(CleanMessagesMojo.this.unreferencedProperties.keySet());
            try {
                FileInputStream s = new FileInputStream(this.sourceFile);
                try {
                    String line;
                    LineNumberReader reader = new LineNumberReader(new InputStreamReader((InputStream)s, CleanMessagesMojo.this.encoding));
                    while ((line = reader.readLine()) != null) {
                        Iterator i = keys.iterator();
                        while (i.hasNext()) {
                            MessagePropertyKey key = (MessagePropertyKey)i.next();
                            if (!key.isPresent(line)) continue;
                            i.remove();
                            CleanMessagesMojo.this.unreferencedProperties.remove(key);
                            CleanMessagesMojo.this.referencedProperties.put(key, "");
                        }
                    }
                }
                finally {
                    try {
                        s.close();
                    }
                    catch (Exception exception) {}
                }
                CleanMessagesMojo.this.fileCount.incrementAndGet();
            }
            catch (IOException e) {
                CleanMessagesMojo.this.getLog().error((CharSequence)("An error occurred while reading source file " + this.sourceFile.getName()), (Throwable)e);
            }
        }
    }
}

