/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.i18n.maven;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class MessagePropertyKey
implements Comparable<MessagePropertyKey> {
    private static final Pattern PATTERN = Pattern.compile("^([A-Z][A-Z0-9_]*?)(_([0-9]+))?$");
    private final String name;
    private final int ordinal;
    private final Pattern startRegex;
    private final Pattern midRegex;
    private final Pattern endRegex;

    static MessagePropertyKey valueOf(String keyString) {
        Matcher matcher = PATTERN.matcher(keyString);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Error processing " + keyString + ". The provided key string must be of the form NAME[_ORDINAL]");
        }
        if (matcher.group(3) == null) {
            return new MessagePropertyKey(keyString, -1);
        }
        String name = matcher.group(1);
        int ordinal = Integer.parseInt(matcher.group(3));
        return new MessagePropertyKey(name, ordinal);
    }

    private MessagePropertyKey(String name, int ordinal) {
        this.name = name;
        this.ordinal = ordinal;
        this.startRegex = Pattern.compile(name + "[^A-Z0-9_].*");
        this.midRegex = Pattern.compile(".*[^A-Z0-9_]" + name + "[^A-Z0-9_].*");
        this.endRegex = Pattern.compile(".*[^A-Z0-9_]" + name);
    }

    @Override
    public int compareTo(MessagePropertyKey k) {
        if (this.ordinal == k.ordinal) {
            return this.name.compareTo(k.name);
        }
        return this.ordinal - k.ordinal;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MessagePropertyKey) {
            MessagePropertyKey k = (MessagePropertyKey)obj;
            return this.compareTo(k) == 0;
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.name.hashCode() + this.ordinal;
    }

    boolean isPresent(String line) {
        if (!line.contains(this.name)) {
            return false;
        }
        if (this.midRegex.matcher(line).matches()) {
            return true;
        }
        if (this.endRegex.matcher(line).matches()) {
            return true;
        }
        if (this.startRegex.matcher(line).matches()) {
            return true;
        }
        return line.equals(this.name);
    }

    public String toString() {
        return this.getName(true);
    }

    String getName() {
        return this.getName(false);
    }

    String getName(boolean includeOrdinal) {
        if (!includeOrdinal || this.ordinal < 0) {
            return this.name;
        }
        StringBuilder builder = new StringBuilder(this.name);
        builder.append("_");
        builder.append(this.ordinal);
        return builder.toString();
    }

    int getOrdinal() {
        return this.ordinal;
    }
}

