/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.i18n.maven;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.UnknownFormatConversionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.forgerock.i18n.maven.MessagePropertyKey;

abstract class AbstractGenerateMessagesMojo
extends AbstractMojo {
    private boolean force;
    private String[] messageFiles;
    private MavenProject project;
    private static final String DESCRIPTOR_CLASS_BASE_NAME = "Arg";
    private static final int DESCRIPTOR_MAX_ARG_HANDLER = 11;
    private static final String SPECIFIER_REGEX = "%(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])";
    private static final Pattern SPECIFIER_PATTERN = Pattern.compile("%(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");
    private static final String EOL = System.getProperty("line.separator");
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    AbstractGenerateMessagesMojo() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void execute() throws MojoExecutionException {
        File resourceDirectory = this.getResourceDirectory();
        if (!resourceDirectory.exists()) {
            throw new MojoExecutionException("Source directory " + resourceDirectory.getPath() + " does not exist");
        }
        if (!resourceDirectory.isDirectory()) {
            throw new MojoExecutionException("Source directory " + resourceDirectory.getPath() + " is not a directory");
        }
        File targetDirectory = this.getTargetDirectory();
        if (!targetDirectory.exists()) {
            if (!targetDirectory.mkdirs()) throw new MojoExecutionException("Unable to create message output directory: " + targetDirectory.getPath());
            this.getLog().info((CharSequence)("Created message output directory: " + targetDirectory.getPath()));
        } else if (!targetDirectory.isDirectory()) {
            throw new MojoExecutionException("Output directory " + targetDirectory.getPath() + " is not a directory");
        }
        if (this.project != null) {
            this.getLog().info((CharSequence)("Adding source directory: " + targetDirectory.getPath()));
            this.addNewSourceDirectory(targetDirectory);
        }
        for (String messageFile : this.messageFiles) {
            this.processMessageFile(new MessageFile(messageFile));
        }
    }

    abstract void addNewSourceDirectory(File var1);

    abstract File getResourceDirectory();

    abstract File getTargetDirectory();

    private InputStream getStubFile() throws MojoExecutionException {
        return ((Object)((Object)this)).getClass().getResourceAsStream("Messages.java.stub");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processMessageFile(MessageFile messageFile) throws MojoExecutionException {
        File resourceDirectory = this.getResourceDirectory();
        File targetDirectory = this.getTargetDirectory();
        File sourceFile = messageFile.getResourceFile(resourceDirectory);
        File outputFile = messageFile.getOutputFile(targetDirectory);
        if (!sourceFile.exists()) {
            throw new MojoExecutionException("Message file " + messageFile.getName() + " does not exist");
        }
        if (outputFile.exists()) {
            if (!this.force && sourceFile.lastModified() <= outputFile.lastModified()) {
                this.getLog().info((CharSequence)(outputFile.getName() + " is up to date"));
                return;
            }
            if (!outputFile.delete()) {
                throw new MojoExecutionException("Unable to continue because the old message file " + messageFile.getName() + " could not be deleted");
            }
            this.getLog().info((CharSequence)("Regenerating " + outputFile.getName() + " from " + sourceFile.getName()));
        } else {
            File packageDirectory = outputFile.getParentFile();
            if (!packageDirectory.exists() && !packageDirectory.mkdirs()) {
                throw new MojoExecutionException("Unable to create message output directory: " + packageDirectory.getPath());
            }
            this.getLog().info((CharSequence)("Generating " + outputFile.getName() + " from " + sourceFile.getName()));
        }
        BufferedReader stubReader = null;
        PrintWriter outputWriter = null;
        try {
            stubReader = new BufferedReader(new InputStreamReader(this.getStubFile(), UTF_8));
            outputWriter = new PrintWriter(outputFile, "UTF-8");
            Properties properties = new Properties();
            FileInputStream propertiesFile = new FileInputStream(sourceFile);
            try {
                properties.load(propertiesFile);
            }
            finally {
                try {
                    propertiesFile.close();
                }
                catch (Exception exception) {}
            }
            String stubLine = stubReader.readLine();
            while (stubLine != null) {
                if (stubLine.contains("${MESSAGES}")) {
                    TreeMap<MessagePropertyKey, String> propertyMap = new TreeMap<MessagePropertyKey, String>();
                    for (Map.Entry<Object, Object> property : properties.entrySet()) {
                        String propKey = property.getKey().toString();
                        MessagePropertyKey key = MessagePropertyKey.valueOf(propKey);
                        propertyMap.put(key, property.getValue().toString());
                    }
                    int usesOfGenericDescriptor = 0;
                    for (Map.Entry property : propertyMap.entrySet()) {
                        MessageDescriptorDeclaration message = new MessageDescriptorDeclaration((MessagePropertyKey)property.getKey(), (String)property.getValue());
                        message.setConstructorArguments(messageFile.getClassName() + ".class", "RESOURCE", this.quote(((MessagePropertyKey)property.getKey()).toString()), String.valueOf(((MessagePropertyKey)property.getKey()).getOrdinal()));
                        outputWriter.println(message.toString());
                        outputWriter.println();
                        if (!message.useGenericMessageTypeClass()) continue;
                        ++usesOfGenericDescriptor;
                    }
                    this.getLog().debug((CharSequence)("  Generated " + propertyMap.size() + " LocalizableMessage"));
                    this.getLog().debug((CharSequence)("  Number of LocalizableMessageDescriptor.ArgN: " + usesOfGenericDescriptor));
                } else {
                    stubLine = stubLine.replace("${PACKAGE}", messageFile.getPackageName());
                    stubLine = stubLine.replace("${CLASS_NAME}", messageFile.getClassName());
                    stubLine = stubLine.replace("${FILE_NAME}", messageFile.getName());
                    stubLine = stubLine.replace("${RESOURCE_BUNDLE_NAME}", messageFile.getResourceBundleName());
                    outputWriter.println(stubLine);
                }
                stubLine = stubReader.readLine();
            }
            return;
        }
        catch (IOException e) {
            if (!outputFile.exists()) throw new MojoExecutionException("An IO error occurred while generating the message file: " + e);
            outputFile.deleteOnExit();
            throw new MojoExecutionException("An IO error occurred while generating the message file: " + e);
        }
        finally {
            if (stubReader != null) {
                try {
                    stubReader.close();
                }
                catch (Exception exception) {}
            }
            if (outputWriter != null) {
                try {
                    outputWriter.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private String quote(String s) {
        return "\"" + s + "\"";
    }

    protected MavenProject getMavenProject() {
        return this.project;
    }

    private static final class MessageDescriptorDeclaration {
        private final MessagePropertyKey key;
        private final String formatString;
        private final List<FormatSpecifier> specifiers;
        private final List<Class<?>> classTypes;
        private String[] constructorArgs;

        MessageDescriptorDeclaration(MessagePropertyKey key, String formatString) {
            this.key = key;
            this.formatString = formatString;
            this.specifiers = this.parse(formatString);
            this.classTypes = new ArrayList();
            for (FormatSpecifier f : this.specifiers) {
                Class<?> c = f.getSimpleConversionClass();
                if (c == null) continue;
                this.classTypes.add(c);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getComment());
            sb.append(this.indent(1));
            sb.append("public static final ");
            sb.append(this.getDescriptorClassDeclaration());
            sb.append(" ");
            sb.append(this.key.getName());
            sb.append(" =");
            sb.append(EOL);
            sb.append(this.indent(5));
            sb.append("new ");
            sb.append(this.getDescriptorClassDeclaration());
            sb.append("(");
            if (this.constructorArgs != null) {
                for (int i = 0; i < this.constructorArgs.length; ++i) {
                    sb.append(this.constructorArgs[i]);
                    if (i >= this.constructorArgs.length - 1) continue;
                    sb.append(", ");
                }
            }
            sb.append(");");
            return sb.toString();
        }

        String getClassTypeVariables() {
            StringBuilder sb = new StringBuilder();
            if (this.classTypes.size() > 0) {
                sb.append("<");
                for (int i = 0; i < this.classTypes.size(); ++i) {
                    Class<?> c = this.classTypes.get(i);
                    if (c == null) continue;
                    sb.append(this.getShortClassName(c));
                    if (i >= this.classTypes.size() - 1) continue;
                    sb.append(", ");
                }
                sb.append(">");
            }
            return sb.toString();
        }

        String getComment() {
            String[] sa;
            StringBuilder sb = new StringBuilder();
            sb.append(this.indent(1)).append("/**").append(EOL);
            String ws = this.formatString;
            for (String s : sa = ws.split(EOL)) {
                sb.append(this.indent(1)).append(" * ").append(s).append(EOL);
            }
            sb.append(this.indent(1)).append(" */").append(EOL);
            return sb.toString();
        }

        String getDescriptorClassDeclaration() {
            StringBuilder sb = new StringBuilder();
            if (this.useGenericMessageTypeClass()) {
                sb.append("LocalizableMessageDescriptor");
                sb.append(".");
                sb.append(AbstractGenerateMessagesMojo.DESCRIPTOR_CLASS_BASE_NAME);
                sb.append("N");
            } else {
                sb.append("LocalizableMessageDescriptor");
                sb.append(".");
                sb.append(AbstractGenerateMessagesMojo.DESCRIPTOR_CLASS_BASE_NAME);
                sb.append(this.classTypes.size());
                sb.append(this.getClassTypeVariables());
            }
            return sb.toString();
        }

        void setConstructorArguments(String ... s) {
            this.constructorArgs = s;
        }

        private void checkText(String s) {
            int idx = s.indexOf(37);
            if (idx != -1) {
                char c = idx > s.length() - 2 ? (char)'%' : (char)s.charAt(idx + 1);
                throw new UnknownFormatConversionException(String.valueOf(c));
            }
        }

        private String getShortClassName(Class<?> c) {
            String fqName = c.getName();
            int i = fqName.lastIndexOf(46);
            String name = i > 0 ? fqName.substring(i + 1) : fqName;
            return name;
        }

        private String indent(int indent) {
            char[] blankArray = new char[4 * indent];
            Arrays.fill(blankArray, ' ');
            return new String(blankArray);
        }

        private List<FormatSpecifier> parse(String s) {
            ArrayList<FormatSpecifier> sl = new ArrayList<FormatSpecifier>();
            Matcher m = SPECIFIER_PATTERN.matcher(s);
            int i = 0;
            while (i < s.length()) {
                if (m.find(i)) {
                    if (m.start() != i) {
                        this.checkText(s.substring(i, m.start()));
                    }
                    String[] sa = new String[6];
                    for (int j = 0; j < m.groupCount(); ++j) {
                        sa[j] = m.group(j + 1);
                    }
                    sl.add(new FormatSpecifier(sa));
                    i = m.end();
                    continue;
                }
                this.checkText(s.substring(i));
                break;
            }
            return sl;
        }

        private boolean useGenericMessageTypeClass() {
            if (this.specifiers.size() > 11) {
                return true;
            }
            for (FormatSpecifier s : this.specifiers) {
                if (!s.specifiesArgumentIndex()) continue;
                return true;
            }
            return false;
        }
    }

    private static final class FormatSpecifier {
        private final String[] sa;

        FormatSpecifier(String[] sa) {
            this.sa = sa;
        }

        Class<?> getSimpleConversionClass() {
            String sa5;
            Class c = null;
            String sa4 = this.sa[4] != null ? this.sa[4].toLowerCase() : null;
            String string = sa5 = this.sa[5] != null ? this.sa[5].toLowerCase() : null;
            if ("t".equals(sa4)) {
                c = Calendar.class;
            } else if ("b".equals(sa5)) {
                c = Boolean.class;
            } else if ("h".equals(sa5)) {
                c = Object.class;
            } else if ("s".equals(sa5)) {
                c = Object.class;
            } else if ("c".equals(sa5)) {
                c = Character.class;
            } else if ("d".equals(sa5) || "o".equals(sa5) || "x".equals(sa5) || "e".equals(sa5) || "f".equals(sa5) || "g".equals(sa5) || "a".equals(sa5)) {
                c = Number.class;
            } else if ("n".equals(sa5) || "%".equals(sa5)) {
                // empty if block
            }
            return c;
        }

        boolean specifiesArgumentIndex() {
            return this.sa[0] != null;
        }
    }

    static final class MessageFile {
        private final String name;

        MessageFile(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        String getClassName() {
            StringBuilder builder = new StringBuilder();
            String shortName = this.getShortName();
            boolean upperCaseNextChar = true;
            for (char c : shortName.toCharArray()) {
                if (c == '_' || c == '-') {
                    upperCaseNextChar = true;
                    continue;
                }
                if (upperCaseNextChar) {
                    builder.append(Character.toUpperCase(c));
                    upperCaseNextChar = false;
                    continue;
                }
                builder.append(c);
            }
            builder.append("Messages");
            return builder.toString();
        }

        String getName() {
            return this.name;
        }

        File getOutputFile(File outputDirectory) {
            int lastSlash = this.name.lastIndexOf(47);
            String parentPath = this.name.substring(0, lastSlash);
            String path = parentPath.replace('/', File.separatorChar) + File.separator + this.getClassName() + ".java";
            return new File(outputDirectory, path);
        }

        String getPackageName() {
            int lastSlash = this.name.lastIndexOf(47);
            String parentPath = this.name.substring(0, lastSlash);
            return parentPath.replace('/', '.');
        }

        String getResourceBundleName() {
            return this.getPackageName() + "." + this.getShortName();
        }

        File getResourceFile(File resourceDirectory) {
            String path = this.name.replace('/', File.separatorChar);
            return new File(resourceDirectory, path);
        }

        String getShortName() {
            int lastSlash = this.name.lastIndexOf(47);
            String fileName = this.name.substring(lastSlash + 1);
            int lastDot = fileName.lastIndexOf(46);
            return fileName.substring(0, lastDot);
        }
    }
}

