/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.servlet;

import java.io.IOException;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.forgerock.http.servlet.Servlet2Adapter;
import org.forgerock.http.servlet.ServletSynchronizer;
import org.forgerock.http.servlet.ServletVersionAdapter;

final class Servlet3Adapter
implements ServletVersionAdapter {
    Servlet3Adapter() {
    }

    @Override
    public ServletSynchronizer createServletSynchronizer(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        if (httpRequest.isAsyncSupported()) {
            return new Servlet3Synchronizer(httpRequest);
        }
        return new Servlet2Adapter.Servlet2Synchronizer();
    }

    private static final class Servlet3Synchronizer
    implements ServletSynchronizer {
        private final AsyncContext asyncContext;

        private Servlet3Synchronizer(HttpServletRequest httpRequest) {
            if (httpRequest.isAsyncStarted()) {
                this.asyncContext = httpRequest.getAsyncContext();
            } else {
                this.asyncContext = httpRequest.startAsync();
                this.asyncContext.setTimeout(0L);
            }
        }

        @Override
        public void setAsyncListener(final Runnable runnable) {
            this.asyncContext.addListener(new AsyncListener(){

                public void onComplete(AsyncEvent event) throws IOException {
                    runnable.run();
                }

                public void onError(AsyncEvent event) throws IOException {
                    runnable.run();
                }

                public void onStartAsync(AsyncEvent event) throws IOException {
                    event.getAsyncContext().addListener((AsyncListener)this);
                }

                public void onTimeout(AsyncEvent event) throws IOException {
                    runnable.run();
                }
            });
        }

        @Override
        public void awaitIfNeeded() throws InterruptedException {
        }

        @Override
        public void signalAndComplete() {
            this.asyncContext.complete();
        }
    }
}

