/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.header;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.forgerock.http.header.HeaderFactory;
import org.forgerock.http.header.HeaderUtil;
import org.forgerock.http.protocol.Cookie;
import org.forgerock.http.protocol.Header;
import org.forgerock.http.protocol.Response;

public class SetCookieHeader
extends Header {
    public static final String NAME = "Set-Cookie";
    private final List<Cookie> cookies;
    private final List<String> values;

    public static SetCookieHeader valueOf(String value) {
        return new SetCookieHeader(Collections.singletonList(SetCookieHeader.parseCookie(value)));
    }

    private static Cookie parseCookie(String value) {
        List<String> parts = Arrays.asList(value.split(";"));
        Cookie cookie = new Cookie();
        for (String part : parts) {
            String[] nvp = part.split("=", 2);
            if ("Expires".equalsIgnoreCase(nvp[0].trim())) {
                cookie.setExpires(HeaderUtil.parseDate(nvp[1].trim()));
                continue;
            }
            if ("Max-Age".equalsIgnoreCase(nvp[0].trim())) {
                cookie.setMaxAge(SetCookieHeader.parseInteger(nvp[1].trim()));
                continue;
            }
            if ("Path".equalsIgnoreCase(nvp[0].trim())) {
                cookie.setPath(nvp[1]);
                continue;
            }
            if ("Domain".equalsIgnoreCase(nvp[0].trim())) {
                cookie.setDomain(nvp[1]);
                continue;
            }
            if ("Secure".equalsIgnoreCase(nvp[0].trim())) {
                cookie.setSecure(true);
                continue;
            }
            if ("HttpOnly".equalsIgnoreCase(nvp[0].trim())) {
                cookie.setHttpOnly(true);
                continue;
            }
            if ("SameSite".equalsIgnoreCase(nvp[0].trim())) {
                cookie.setSameSite(Cookie.SameSite.parse(nvp[1].trim()));
                continue;
            }
            if (cookie.getName() != null && !cookie.getName().isEmpty()) continue;
            cookie.setName(nvp[0].trim());
            cookie.setValue(nvp[1].trim());
        }
        if (cookie.getName() == null || cookie.getName().isEmpty()) {
            cookie = new Cookie();
        }
        return cookie;
    }

    public static SetCookieHeader valueOf(Response response) {
        if (response == null || !response.getHeaders().containsKey(NAME)) {
            return null;
        }
        return SetCookieHeader.valueOf(response.getHeaders().get(NAME).getValues());
    }

    public static SetCookieHeader valueOf(List<String> values) {
        if (values == null) {
            return null;
        }
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        for (String headerValue : values) {
            cookies.add(SetCookieHeader.parseCookie(headerValue));
        }
        return new SetCookieHeader(Collections.unmodifiableList(cookies));
    }

    private static Integer parseInteger(String s) {
        try {
            return Integer.valueOf(s);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public SetCookieHeader(List<Cookie> cookies) {
        this.cookies = cookies;
        if (cookies != null) {
            this.values = new ArrayList<String>();
            for (Cookie cookie : cookies) {
                this.values.add(this.toString(cookie));
            }
        } else {
            this.values = null;
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public List<String> getValues() {
        return this.values;
    }

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    private String toString(Cookie cookie) {
        StringBuilder sb = new StringBuilder();
        if (cookie.getName() != null) {
            sb.append(cookie.getName()).append("=").append(cookie.getValue());
            if (cookie.getExpires() != null) {
                sb.append("; ").append("Expires").append("=").append(HeaderUtil.formatDate(cookie.getExpires()));
            }
            if (cookie.getMaxAge() != null && cookie.getMaxAge() > -1) {
                sb.append("; ").append("Max-Age").append("=").append(cookie.getMaxAge());
            }
            if (cookie.getPath() != null) {
                sb.append("; ").append("Path").append("=").append(cookie.getPath());
            }
            if (cookie.getDomain() != null) {
                sb.append("; ").append("Domain").append("=").append(cookie.getDomain());
            }
            if (cookie.isSecure() != null && cookie.isSecure().booleanValue() || cookie.getSameSite() == Cookie.SameSite.NONE) {
                sb.append("; ").append("Secure");
            }
            if (cookie.isHttpOnly() != null && cookie.isHttpOnly().booleanValue()) {
                sb.append("; ").append("HttpOnly");
            }
            if (cookie.getSameSite() != null) {
                sb.append("; SameSite=").append((Object)cookie.getSameSite());
            }
        }
        return sb.toString();
    }

    static class Factory
    extends HeaderFactory<SetCookieHeader> {
        Factory() {
        }

        @Override
        public SetCookieHeader parse(String value) {
            return SetCookieHeader.valueOf(value);
        }

        @Override
        public SetCookieHeader parse(List<String> values) {
            return SetCookieHeader.valueOf(values);
        }
    }
}

