/*
 * The contents of this file are subject to the terms of the Common Development and
 * Distribution License (the License). You may not use this file except in compliance with the
 * License.
 *
 * You can obtain a copy of the License at legal/CDDLv1.0.txt. See the License for the
 * specific language governing permission and limitations under the License.
 *
 * When distributing Covered Software, include this CDDL Header Notice in each file and include
 * the License file at legal/CDDLv1.0.txt. If applicable, add the following below the CDDL
 * Header, with the fields enclosed by brackets [] replaced by your own identifying
 * information: "Portions copyright [year] [name of copyright owner]".
 *
 * Copyright 2016 ForgeRock AS.
 */
package org.forgerock.http.swagger;

import io.swagger.models.Swagger;

/** Swagger utility. */
public final class SwaggerUtils {

    /**
     * Clone a {@code Swagger} instance.
     * @param descriptor The instance to clone.
     * @return The newly cloned instance.
     */
    public static Swagger clone(Swagger descriptor) {
        Swagger swagger = new SwaggerExtended()
                .basePath(descriptor.getBasePath())
                .consumes(descriptor.getConsumes())
                .info(descriptor.getInfo())
                .produces(descriptor.getProduces())
                .responses(descriptor.getResponses())
                .schemes(descriptor.getSchemes())
                .tags(descriptor.getTags())
                .vendorExtensions(descriptor.getVendorExtensions());
        swagger.setDefinitions(descriptor.getDefinitions());
        swagger.setPaths(descriptor.getPaths());
        swagger.setSecurity(descriptor.getSecurity());
        swagger.setParameters(descriptor.getParameters());
        swagger.setSecurityDefinitions(descriptor.getSecurityDefinitions());
        return swagger;
    }

    private SwaggerUtils() {
        // utility class
    }
}
