/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.forgerock.http.util.Indexed;

public final class Loader {
    private Loader() {
    }

    public static ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static Class<?> getClass(String name) {
        try {
            return Class.forName(name, true, Loader.getClassLoader());
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static Object newInstance(String name) {
        try {
            return Loader.getClass(name).newInstance();
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static <T> T newInstance(String name, Class<T> type) {
        Object object = Loader.newInstance(name);
        if (object != null && !type.isInstance(object)) {
            object = null;
        }
        return (T)object;
    }

    public static <K, V extends Indexed<K>> Map<K, V> loadMap(Class<K> keyType, Class<V> serviceType) {
        HashMap map = new HashMap();
        for (Indexed v : ServiceLoader.load(serviceType, Loader.getClassLoader())) {
            map.put(v.getKey(), v);
        }
        return map;
    }

    public static <E> List<E> loadList(Class<E> serviceType) {
        ArrayList<E> list = new ArrayList<E>();
        for (E e : ServiceLoader.load(serviceType, Loader.getClassLoader())) {
            list.add(e);
        }
        return list;
    }

    public static URL getResource(String name) {
        return Loader.getClassLoader().getResource(name);
    }
}

