/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.routing;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.forgerock.json.JsonValue;
import org.forgerock.services.context.AbstractContext;
import org.forgerock.services.context.Context;
import org.forgerock.util.Reject;

public final class UriRouterContext
extends AbstractContext {
    private static final String ATTR_MATCHED_URI = "matchedUri";
    private static final String ATTR_REMAINIG_URI = "remainingUri";
    private static final String ATTR_URI_TEMPLATE_VARIABLES = "uriTemplateVariables";
    private static final String ATTR_ORIGINAL_URI = "originalUri";
    private final Map<String, String> uriTemplateVariables;
    private URI originalUri;

    public UriRouterContext(Context parent, String matchedUri, String remainingUri, Map<String, String> uriTemplateVariables) {
        this(parent, matchedUri, remainingUri, uriTemplateVariables, null);
    }

    public UriRouterContext(Context parent, String matchedUri, String remainingUri, Map<String, String> uriTemplateVariables, URI originalUri) {
        super((Context)Reject.checkNotNull((Object)parent, (String)"Cannot instantiate UriRouterContext with null parent Context"), "router");
        this.data.put(ATTR_MATCHED_URI, (Object)matchedUri);
        this.data.put(ATTR_REMAINIG_URI, (Object)remainingUri);
        this.uriTemplateVariables = Collections.unmodifiableMap(uriTemplateVariables);
        this.data.put(ATTR_URI_TEMPLATE_VARIABLES, this.uriTemplateVariables);
        if (originalUri != null) {
            this.originalUri = originalUri;
            this.data.put(ATTR_ORIGINAL_URI, (Object)originalUri.toASCIIString());
        }
    }

    public UriRouterContext(JsonValue savedContext, ClassLoader classLoader) {
        super(savedContext, classLoader);
        this.uriTemplateVariables = Collections.unmodifiableMap(this.data.get(ATTR_URI_TEMPLATE_VARIABLES).required().asMap(String.class));
        String savedUri = this.data.get(ATTR_ORIGINAL_URI).asString();
        try {
            this.originalUri = new URI(savedUri);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(String.format("The URI %s is not valid", savedUri));
        }
    }

    public String getBaseUri() {
        String matchedUri;
        String baseUri;
        StringBuilder builder = new StringBuilder();
        Context parent = this.getParent();
        if (parent.containsContext(UriRouterContext.class) && !(baseUri = parent.asContext(UriRouterContext.class).getBaseUri()).isEmpty()) {
            builder.append(baseUri);
        }
        if ((matchedUri = this.getMatchedUri()).length() > 0) {
            if (builder.length() > 0) {
                builder.append('/');
            }
            builder.append(matchedUri);
        }
        return builder.toString();
    }

    public String getMatchedUri() {
        return this.data.get(ATTR_MATCHED_URI).asString();
    }

    public String getRemainingUri() {
        return this.data.get(ATTR_REMAINIG_URI).asString();
    }

    public Map<String, String> getUriTemplateVariables() {
        return this.uriTemplateVariables;
    }

    public URI getOriginalUri() {
        Context parent = this.getParent();
        if (this.originalUri != null) {
            return this.originalUri;
        }
        if (parent.containsContext(UriRouterContext.class)) {
            return parent.asContext(UriRouterContext.class).getOriginalUri();
        }
        return null;
    }

    public static Builder uriRouterContext(Context parent) {
        return new Builder(parent);
    }

    public static class Builder {
        private final Context parent;
        private String matchedUri;
        private String remainingUri;
        private URI originalUri;
        private Map<String, String> variables = new LinkedHashMap<String, String>();

        Builder(Context parent) {
            this.parent = parent;
        }

        public Builder matchedUri(String matchedUri) {
            this.matchedUri = matchedUri;
            return this;
        }

        public Builder remainingUri(String remainingUri) {
            this.remainingUri = remainingUri;
            return this;
        }

        public Builder originalUri(URI originalUri) {
            this.originalUri = originalUri;
            return this;
        }

        public Builder templateVariables(Map<String, String> variables) {
            this.variables = (Map)Reject.checkNotNull(variables);
            return this;
        }

        public Builder templateVariable(String name, String value) {
            this.variables.put(name, value);
            return this;
        }

        public UriRouterContext build() {
            return new UriRouterContext(this.parent, this.matchedUri, this.remainingUri, this.variables, this.originalUri);
        }
    }
}

