/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.header;

import java.util.Collections;
import java.util.List;
import org.forgerock.http.header.AbstractSingleValuedHeaderFactory;
import org.forgerock.http.header.HeaderUtil;
import org.forgerock.http.header.MalformedHeaderException;
import org.forgerock.http.protocol.Header;
import org.forgerock.http.protocol.Request;
import org.forgerock.services.TransactionId;

public final class TransactionIdHeader
extends Header {
    public static final String NAME = "X-ForgeRock-TransactionId";
    private TransactionId transactionId = null;

    public static TransactionIdHeader valueOf(Request request) throws MalformedHeaderException {
        return TransactionIdHeader.valueOf(HeaderUtil.parseSingleValuedHeader(request, NAME));
    }

    public static TransactionIdHeader valueOf(String value) throws MalformedHeaderException {
        return new TransactionIdHeader(value);
    }

    public TransactionIdHeader(String value) throws MalformedHeaderException {
        try {
            this.transactionId = new TransactionId(value);
        }
        catch (IllegalArgumentException e) {
            throw new MalformedHeaderException(e);
        }
    }

    public TransactionId getTransactionId() {
        return this.transactionId;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public List<String> getValues() {
        return this.transactionId != null ? Collections.singletonList(this.transactionId.getValue()) : Collections.emptyList();
    }

    static class Factory
    extends AbstractSingleValuedHeaderFactory<TransactionIdHeader> {
        Factory() {
        }

        @Override
        public TransactionIdHeader parse(String value) throws MalformedHeaderException {
            return TransactionIdHeader.valueOf(value);
        }
    }
}

