/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.apache.sync;

import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.forgerock.http.apache.AbstractHttpClient;
import org.forgerock.http.io.Buffer;
import org.forgerock.http.protocol.Request;
import org.forgerock.http.protocol.Response;
import org.forgerock.http.protocol.Responses;
import org.forgerock.util.Factory;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;

final class SyncHttpClient
extends AbstractHttpClient {
    private final CloseableHttpClient httpClient;

    SyncHttpClient(CloseableHttpClient httpClient, Factory<Buffer> storage) {
        super(storage);
        this.httpClient = httpClient;
    }

    public void close() throws IOException {
        this.httpClient.close();
    }

    public Promise<Response, NeverThrowsException> sendAsync(Request request) {
        try {
            HttpUriRequest clientRequest = this.createHttpUriRequest(request);
            CloseableHttpResponse clientResponse = this.httpClient.execute(clientRequest);
            Response response = this.createResponse((HttpResponse)clientResponse);
            return Promises.newResultPromise((Object)response);
        }
        catch (IOException e) {
            return Promises.newResultPromise((Object)Responses.newInternalServerError((Exception)e));
        }
    }
}

