/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.apache.sync;

import java.net.ProxySelector;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.forgerock.http.HttpApplicationException;
import org.forgerock.http.apache.NoAuthenticationStrategy;
import org.forgerock.http.apache.sync.SyncHttpClient;
import org.forgerock.http.handler.HttpClientHandler;
import org.forgerock.http.io.Buffer;
import org.forgerock.http.spi.HttpClient;
import org.forgerock.http.spi.HttpClientProvider;
import org.forgerock.http.util.Lists;
import org.forgerock.util.Factory;
import org.forgerock.util.Options;
import org.forgerock.util.time.Duration;

public final class SyncHttpClientProvider
implements HttpClientProvider {
    public HttpClient newHttpClient(Options options) throws HttpApplicationException {
        NoopHostnameVerifier hostnameVerifier;
        SSLContext context;
        Factory storage = (Factory)options.get(HttpClientHandler.OPTION_TEMPORARY_STORAGE);
        HttpClientBuilder builder = HttpClientBuilder.create();
        int maxConnections = (Integer)options.get(HttpClientHandler.OPTION_MAX_CONNECTIONS);
        builder.setMaxConnTotal(maxConnections);
        builder.setMaxConnPerRoute(maxConnections);
        if (!((Boolean)options.get(HttpClientHandler.OPTION_REUSE_CONNECTIONS)).booleanValue()) {
            builder.setConnectionReuseStrategy((ConnectionReuseStrategy)NoConnectionReuseStrategy.INSTANCE);
        }
        if (!((Boolean)options.get(HttpClientHandler.OPTION_RETRY_REQUESTS)).booleanValue()) {
            builder.disableAutomaticRetries();
        }
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        Duration soTimeout = (Duration)options.get(HttpClientHandler.OPTION_SO_TIMEOUT);
        requestConfigBuilder.setSocketTimeout(soTimeout.isUnlimited() ? 0 : (int)soTimeout.to(TimeUnit.MILLISECONDS));
        Duration connectTimeout = (Duration)options.get(HttpClientHandler.OPTION_CONNECT_TIMEOUT);
        requestConfigBuilder.setConnectTimeout(connectTimeout.isUnlimited() ? 0 : (int)connectTimeout.to(TimeUnit.MILLISECONDS));
        builder.setDefaultRequestConfig(requestConfigBuilder.build());
        builder.disableRedirectHandling();
        try {
            context = SSLContext.getInstance((String)options.get(HttpClientHandler.OPTION_SSLCONTEXT_ALGORITHM));
            context.init((KeyManager[])options.get(HttpClientHandler.OPTION_KEY_MANAGERS), (TrustManager[])options.get(HttpClientHandler.OPTION_TRUST_MANAGERS), null);
        }
        catch (GeneralSecurityException e) {
            throw new HttpApplicationException((Throwable)e);
        }
        switch ((HttpClientHandler.HostnameVerifier)options.get(HttpClientHandler.OPTION_HOSTNAME_VERIFIER)) {
            case ALLOW_ALL: {
                hostnameVerifier = NoopHostnameVerifier.INSTANCE;
                break;
            }
            default: {
                hostnameVerifier = new DefaultHostnameVerifier();
            }
        }
        List protocols = (List)options.get(HttpClientHandler.OPTION_SSL_ENABLED_PROTOCOLS);
        List ciphers = (List)options.get(HttpClientHandler.OPTION_SSL_CIPHER_SUITES);
        builder.setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(context, Lists.asArrayOrNull((List)protocols), Lists.asArrayOrNull((List)ciphers), (HostnameVerifier)hostnameVerifier));
        AuthenticationStrategy proxyStrategy = NoAuthenticationStrategy.INSTANCE;
        ProxyAuthenticationStrategy proxyAuthenticationStrategy = null;
        HttpClientHandler.ProxyInfo proxyInfo = (HttpClientHandler.ProxyInfo)options.get(HttpClientHandler.OPTION_PROXY);
        if (proxyInfo != null) {
            URI uri = proxyInfo.getProxyUri();
            builder.setProxy(new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme()));
            if (proxyInfo.hasCredentials()) {
                UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(proxyInfo.getUsername(), proxyInfo.getPassword());
                AuthScope authScope = new AuthScope(uri.getHost(), uri.getPort());
                BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
                basicCredentialsProvider.setCredentials(authScope, (Credentials)usernamePasswordCredentials);
                builder.setDefaultCredentialsProvider((CredentialsProvider)basicCredentialsProvider);
                proxyAuthenticationStrategy = ProxyAuthenticationStrategy.INSTANCE;
            }
        } else if (((Boolean)options.get(HttpClientHandler.OPTION_PROXY_SYSTEM)).booleanValue()) {
            builder.setRoutePlanner((HttpRoutePlanner)new SystemDefaultRoutePlanner(ProxySelector.getDefault()));
        }
        builder.disableCookieManagement();
        builder.setProxyAuthenticationStrategy(proxyAuthenticationStrategy);
        builder.setTargetAuthenticationStrategy(NoAuthenticationStrategy.INSTANCE);
        return new SyncHttpClient(builder.build(), (Factory<Buffer>)storage);
    }
}

