/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.bindings;

import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertionError;
import org.assertj.core.api.SoftAssertions;
import org.forgerock.http.ApiProducer;
import org.forgerock.http.Applications;
import org.forgerock.http.Client;
import org.forgerock.http.DescribedHttpApplication;
import org.forgerock.http.Handler;
import org.forgerock.http.HttpApplication;
import org.forgerock.http.HttpApplicationException;
import org.forgerock.http.handler.HttpClientHandler;
import org.forgerock.http.header.CookieHeader;
import org.forgerock.http.header.SetCookieHeader;
import org.forgerock.http.protocol.Header;
import org.forgerock.http.protocol.Request;
import org.forgerock.http.protocol.Response;
import org.forgerock.http.protocol.Status;
import org.forgerock.http.routing.UriRouterContext;
import org.forgerock.http.session.Session;
import org.forgerock.http.session.SessionContext;
import org.forgerock.services.context.ClientContext;
import org.forgerock.services.context.Context;
import org.forgerock.services.descriptor.Describable;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;
import org.mockito.Mockito;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public abstract class BindingTest {
    private int port;

    protected abstract void createServer();

    protected abstract void stopServer() throws Exception;

    protected abstract int startServer() throws Exception;

    protected abstract void addApplication(HttpApplication var1) throws Exception;

    @BeforeMethod
    public final void setUp() throws Exception {
        this.createServer();
    }

    @AfterMethod
    public final void tearDown() throws Exception {
        this.stopServer();
        this.port = 0;
    }

    @Test
    public void testDescribedHttpApplicationLifecycle() throws Exception {
        DescribedHttpApplication application = (DescribedHttpApplication)Mockito.mock(DescribedHttpApplication.class);
        Mockito.when((Object)application.start()).thenReturn((Object)((Handler)Mockito.mock(DescribableHandler.class)));
        this.addApplication((HttpApplication)application);
        this.port = this.startServer();
        ((DescribedHttpApplication)Mockito.verify((Object)application)).getBufferFactory();
        ((DescribedHttpApplication)Mockito.verify((Object)application)).start();
        ((DescribedHttpApplication)Mockito.verify((Object)application)).getApiProducer();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{application});
        this.stopServer();
        ((DescribedHttpApplication)Mockito.verify((Object)application)).stop();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{application});
    }

    @Test
    public void testHttpApplicationLifecycle() throws Exception {
        HttpApplication application = (HttpApplication)Mockito.mock(HttpApplication.class);
        this.addApplication(application);
        this.port = this.startServer();
        ((HttpApplication)Mockito.verify((Object)application)).getBufferFactory();
        ((HttpApplication)Mockito.verify((Object)application)).start();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{application});
        this.stopServer();
        ((HttpApplication)Mockito.verify((Object)application)).stop();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{application});
    }

    @Test
    public void testAnswerWith500IfHttpApplicationFailedToStart() throws Exception {
        HttpApplication application = (HttpApplication)Mockito.mock(HttpApplication.class);
        this.addApplication(application);
        Mockito.when((Object)application.start()).thenThrow(new Throwable[]{new HttpApplicationException("Unable to start the HttpApplication")});
        this.port = this.startServer();
        try (HttpClientHandler handler = new HttpClientHandler();){
            Client client = new Client((Handler)handler);
            Request request = new Request().setMethod("GET").setUri(String.format("http://localhost:%d/test", this.port));
            Response response = (Response)client.send(request).get();
            Assertions.assertThat((Object)response.getStatus()).isEqualTo((Object)Status.INTERNAL_SERVER_ERROR);
        }
    }

    @Test
    public void testRequest() throws Exception {
        HttpApplication application = Applications.simpleHttpApplication((Handler)new TestHandler(), null);
        this.addApplication(application);
        this.port = this.startServer();
        try (HttpClientHandler handler = new HttpClientHandler();){
            Client client = new Client((Handler)handler);
            Request request = new Request().setMethod("POST").setUri(String.format("http://localhost:%d/test", this.port));
            request.getHeaders().add("X-WhateverHeader", (Object)"Whatever Value");
            request.getEntity().setString("Hello");
            Response response = (Response)client.send(request).get();
            Assertions.assertThat((String)response.getEntity().toString()).isEqualTo((Object)"HELLO");
            Assertions.assertThat((String)response.getHeaders().get((Object)"X-WhateverHeader").getFirstValue()).isEqualTo((Object)"Whatever Value");
        }
    }

    @Test
    public void testSession() throws Exception {
        HttpApplication application = Applications.simpleHttpApplication((Handler)new TestSessionHandler(), null);
        this.addApplication(application);
        this.port = this.startServer();
        try (HttpClientHandler handler = new HttpClientHandler();){
            Client client = new Client((Handler)handler);
            Request populate = new Request().setMethod("POST").setUri(String.format("http://localhost:%d/populate", this.port));
            Response response = (Response)client.send(populate).get();
            Assertions.assertThat((Object)response.getStatus()).isEqualTo((Object)Status.OK);
            List sessionCookie = ((SetCookieHeader)response.getHeaders().get(SetCookieHeader.class)).getCookies();
            Request check = new Request().setMethod("POST").setUri(String.format("http://localhost:%d/check", this.port));
            check.getHeaders().put((Header)new CookieHeader(sessionCookie));
            response = (Response)client.send(check).get();
            Assertions.assertThat((String)response.getEntity().toString()).isEqualTo((Object)"OK");
        }
    }

    static interface DescribableHandler
    extends Handler,
    Describable<Swagger, Request> {
    }

    private final class TestSessionHandler
    implements Handler {
        private TestSessionHandler() {
        }

        public Promise<Response, NeverThrowsException> handle(Context context, Request request) {
            Session session = ((SessionContext)context.asContext(SessionContext.class)).getSession();
            try {
                if (request.getUri().toASCIIString().endsWith("/populate")) {
                    Assertions.assertThat((boolean)session.isEmpty()).isTrue();
                    Assertions.assertThat((int)session.size()).isEqualTo(0);
                    Assertions.assertThat((boolean)session.containsKey((Object)"sessionKey")).isFalse();
                    Assertions.assertThat((boolean)session.containsValue((Object)"sessionValue")).isFalse();
                    Assertions.assertThat((Object)session.put((Object)"sessionKey", (Object)"sessionValue")).isNull();
                } else if (request.getUri().toASCIIString().endsWith("/check")) {
                    Assertions.assertThat((Object)session.get((Object)"sessionKey")).isEqualTo((Object)"sessionValue");
                    Assertions.assertThat((boolean)session.isEmpty()).isFalse();
                    Assertions.assertThat((int)session.size()).isEqualTo(1);
                    Assertions.assertThat((boolean)session.containsKey((Object)"sessionKey")).isTrue();
                    Assertions.assertThat((boolean)session.containsValue((Object)"sessionValue")).isTrue();
                } else {
                    Assertions.fail((String)("Unsupported URI: " + request.getUri().toString()));
                }
                Response response = new Response(Status.OK);
                response.setEntity((Object)"OK");
                return Response.newResponsePromise((Response)response);
            }
            catch (AssertionError e) {
                return Response.newResponsePromise((Response)new Response(Status.INTERNAL_SERVER_ERROR).setEntity((Object)((Throwable)((Object)e)).getMessage()).setCause(new Exception((Throwable)((Object)e))));
            }
        }
    }

    private final class TestHandler
    implements Handler,
    Describable<Swagger, Request> {
        private TestHandler() {
        }

        public Promise<Response, NeverThrowsException> handle(Context context, Request request) {
            SoftAssertions softly = new SoftAssertions();
            try {
                softly.assertThat(request.getMethod()).isEqualTo((Object)"POST");
                softly.assertThat(request.getUri().getPath()).isEqualTo((Object)"/test");
                softly.assertThat(request.getEntity().toString()).isEqualTo((Object)"Hello");
                softly.assertThat(request.getHeaders().get((Object)"X-WhateverHeader").getFirstValue()).isEqualTo((Object)"Whatever Value");
                softly.assertThat((Object)((UriRouterContext)context.asContext(UriRouterContext.class))).isNotNull();
                softly.assertThat(((UriRouterContext)context.asContext(UriRouterContext.class)).getMatchedUri()).isEmpty();
                softly.assertThat(((UriRouterContext)context.asContext(UriRouterContext.class)).getOriginalUri().toString()).isEqualTo((Object)String.format("http://localhost:%d/test", BindingTest.this.port));
                softly.assertThat((Object)((SessionContext)context.asContext(SessionContext.class))).isNotNull();
                softly.assertThat((Map)((SessionContext)context.asContext(SessionContext.class)).getSession()).isNotNull();
                softly.assertThat((Object)((ClientContext)context.asContext(ClientContext.class))).isNotNull();
                softly.assertThat(((ClientContext)context.asContext(ClientContext.class)).getLocalPort()).isEqualTo(BindingTest.this.port);
                softly.assertAll();
                Response response = new Response(Status.OK);
                response.getHeaders().addAll(request.getHeaders().asMapOfHeaders());
                response.setEntity((Object)request.getEntity().toString().toUpperCase());
                return Response.newResponsePromise((Response)response);
            }
            catch (SoftAssertionError e) {
                return Response.newResponsePromise((Response)new Response(Status.INTERNAL_SERVER_ERROR).setEntity((Object)e.getMessage()).setCause(new Exception(e)));
            }
        }

        public Swagger api(ApiProducer<Swagger> producer) {
            return null;
        }

        public Swagger handleApiRequest(Context context, Request request) {
            return new Swagger().path("test", new Path().post(new Operation().produces("text/plain")));
        }

        public void addDescriptorListener(Describable.Listener listener) {
        }

        public void removeDescriptorListener(Describable.Listener listener) {
        }
    }
}

