/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.guice.core;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.util.ArrayList;
import org.forgerock.guice.core.GuiceModules;
import org.forgerock.guice.core.InjectorHolder;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

public abstract class GuiceTestCase
implements Module {
    private Injector oldInjector;

    @BeforeMethod
    public void setupGuiceModules() throws Exception {
        ArrayList<Module> modules = new ArrayList<Module>();
        modules.add(this);
        GuiceModules guiceModules = this.getClass().getAnnotation(GuiceModules.class);
        if (guiceModules != null) {
            for (Class<? extends Module> moduleType : guiceModules.value()) {
                modules.add(moduleType.newInstance());
            }
        }
        final GuiceTestCase testCase = this;
        Module overrideModule = new Module(){

            public void configure(Binder binder) {
                testCase.configureOverrideBindings(binder);
            }
        };
        this.oldInjector = InjectorHolder.getInjector();
        Injector injector = Guice.createInjector((Module[])new Module[]{Modules.override(modules).with(new Module[]{overrideModule})});
        InjectorHolder.INSTANCE.register(injector);
    }

    @AfterMethod
    public void teardownGuiceModules() throws Exception {
        InjectorHolder.INSTANCE.register(this.oldInjector);
    }

    public void configure(Binder binder) {
    }

    protected void configureOverrideBindings(Binder binder) {
    }
}

