/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit;

import java.io.IOException;
import java.io.InputStream;
import org.forgerock.audit.AuditException;
import org.forgerock.audit.AuditService;
import org.forgerock.audit.AuditServiceBuilder;
import org.forgerock.audit.AuditServiceConfiguration;
import org.forgerock.audit.json.AuditJsonConfig;
import org.forgerock.http.Handler;
import org.forgerock.http.HttpApplication;
import org.forgerock.http.HttpApplicationException;
import org.forgerock.http.io.Buffer;
import org.forgerock.http.routing.RouteMatchers;
import org.forgerock.http.routing.Router;
import org.forgerock.http.routing.RoutingMode;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.ConnectionFactory;
import org.forgerock.json.resource.RequestHandler;
import org.forgerock.json.resource.Resources;
import org.forgerock.json.resource.ServiceUnavailableException;
import org.forgerock.json.resource.http.CrestHttp;
import org.forgerock.util.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuditHttpApplication
implements HttpApplication {
    private static final Logger logger = LoggerFactory.getLogger(AuditHttpApplication.class);
    public static final String AUDIT_EVENT_HANDLERS_CONFIG = "/conf/audit-event-handlers.json";
    public static final String EVENT_HANDLERS = "eventHandlers";
    public static final String AUDIT_ROOT_PATH = "/audit";

    public Handler start() throws HttpApplicationException {
        Router router = new Router();
        AuditServiceConfiguration auditServiceConfiguration = AuditHttpApplication.loadAuditServiceConfiguration();
        AuditServiceBuilder auditServiceBuilder = AuditServiceBuilder.newAuditService();
        auditServiceBuilder.withConfiguration(auditServiceConfiguration);
        try (InputStream eventHandlersConfig = this.getClass().getResourceAsStream(AUDIT_EVENT_HANDLERS_CONFIG);){
            JsonValue auditEventHandlers = AuditJsonConfig.getJson((InputStream)eventHandlersConfig).get(EVENT_HANDLERS);
            for (JsonValue handlerConfig : auditEventHandlers) {
                try {
                    AuditJsonConfig.registerHandlerToService((JsonValue)handlerConfig, (AuditServiceBuilder)auditServiceBuilder, (ClassLoader)this.getClass().getClassLoader());
                }
                catch (Exception ex) {
                    logger.error("Unable to register handler defined by config: " + handlerConfig, (Throwable)ex);
                }
            }
        }
        catch (IOException | AuditException e) {
            logger.error("Failed to read audit event handler configurations", (Throwable)e);
            throw new HttpApplicationException((Throwable)e);
        }
        AuditService auditService = auditServiceBuilder.build();
        try {
            auditService.startup();
        }
        catch (ServiceUnavailableException e) {
            logger.error("Unable to start audit service", (Throwable)e);
            throw new HttpApplicationException((Throwable)e);
        }
        router.addRoute(RouteMatchers.requestUriMatcher((RoutingMode)RoutingMode.STARTS_WITH, (String)AUDIT_ROOT_PATH), (Object)CrestHttp.newHttpHandler((ConnectionFactory)Resources.newInternalConnectionFactory((RequestHandler)auditService)));
        return router;
    }

    public Factory<Buffer> getBufferFactory() {
        return null;
    }

    public void stop() {
    }

    private static AuditServiceConfiguration loadAuditServiceConfiguration() {
        AuditServiceConfiguration auditServiceConfiguration;
        block8: {
            InputStream inputStream = AuditHttpApplication.getResourceAsStream("/conf/audit-service.json");
            try {
                auditServiceConfiguration = AuditJsonConfig.parseAuditServiceConfiguration((InputStream)inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | AuditException e) {
                    RuntimeException exception = new RuntimeException("Error while configuring the audit service", e);
                    logger.error(exception.getMessage(), (Throwable)e);
                    throw exception;
                }
            }
            inputStream.close();
        }
        return auditServiceConfiguration;
    }

    private static InputStream getResourceAsStream(String path) {
        return AuditHttpApplication.class.getResourceAsStream(path);
    }
}

