/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.handlers.syslog;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import org.forgerock.audit.handlers.syslog.SyslogConnection;
import org.forgerock.util.Reject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TcpSyslogConnection
implements SyslogConnection {
    private static final Logger logger = LoggerFactory.getLogger(TcpSyslogConnection.class);
    private final SocketAddress socketAddress;
    private final int connectTimeout;
    private Socket socket = null;
    private OutputStream outputStream;

    TcpSyslogConnection(InetSocketAddress socketAddress, int connectTimeout) {
        this.socketAddress = socketAddress;
        this.connectTimeout = connectTimeout;
    }

    @Override
    public void reconnect() throws IOException {
        if (this.socket == null) {
            this.connect();
        } else if (!this.socket.isConnected() || this.socket.isClosed()) {
            this.close();
            this.connect();
        }
    }

    private void connect() throws IOException {
        this.socket = new Socket();
        this.socket.connect(this.socketAddress, this.connectTimeout);
        this.socket.setKeepAlive(true);
        this.outputStream = new BufferedOutputStream(this.socket.getOutputStream());
    }

    @Override
    public void send(byte[] syslogMessage) throws IOException {
        Reject.ifNull((Object)this.outputStream, (String)"TCP connection must be established before calling send");
        this.outputStream.write(String.valueOf(syslogMessage.length).getBytes(StandardCharsets.UTF_8));
        this.outputStream.write(32);
        this.outputStream.write(syslogMessage);
    }

    @Override
    public void flush() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.flush();
        }
    }

    @Override
    public void close() {
        try {
            this.flush();
        }
        catch (IOException e) {
            logger.warn("Error when flushing the connection", (Throwable)e);
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException closeException) {
                logger.warn("Unable to close Syslog TCP connection", (Throwable)closeException);
            }
        }
        this.socket = null;
    }
}

