/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.handlers.csv;

import java.io.File;
import java.io.PrintStream;
import java.nio.file.Path;
import java.security.PublicKey;
import java.util.HashSet;
import java.util.List;
import javax.crypto.SecretKey;
import org.forgerock.audit.handlers.csv.CsvSecureArchiveVerifier;
import org.forgerock.audit.handlers.csv.CsvSecureVerifier;
import org.forgerock.audit.retention.FileNamingPolicy;
import org.forgerock.audit.retention.TimeStampFileNamingPolicy;
import org.forgerock.audit.secure.JcaKeyStoreHandler;
import org.forgerock.audit.secure.KeyStoreHandler;
import org.forgerock.audit.secure.KeyStoreHandlerDecorator;
import org.forgerock.audit.secure.SecureStorageException;
import org.forgerock.util.Option;
import org.forgerock.util.Options;
import org.forgerock.util.annotations.VisibleForTesting;
import org.forgerock.util.encode.Base64;
import org.supercsv.prefs.CsvPreference;

public final class CsvSecureArchiveVerifierCli {
    private static final Option<Path> ARCHIVE_DIRECTORY = Option.of(Path.class, null);
    private static final Option<String> TOPIC = Option.of(String.class, null);
    private static final Option<String> PREFIX = Option.of(String.class, (Object)"");
    private static final Option<String> SUFFIX = Option.of(String.class, (Object)"-yyyy.MM.dd-HH.mm.ss.gz");
    private static final Option<Path> KEYSTORE_FILE = Option.of(Path.class, null);
    private static final Option<String> KEYSTORE_PASSWORD = Option.of(String.class, null);
    @VisibleForTesting
    static PrintStream out = System.out;
    @VisibleForTesting
    static PrintStream err = System.err;
    @VisibleForTesting
    static FileNamingPolicyFactory fileNamingPolicyFactory = new DefaultFileNamingPolicyFactory();

    public static void main(String[] args) {
        String keystorePassword;
        Options options = new OptionsParser(out, err).parse(args);
        if (options == null) {
            return;
        }
        Path archiveDirectory = (Path)options.get(ARCHIVE_DIRECTORY);
        String topic = (String)options.get(TOPIC);
        File liveFile = new File(archiveDirectory.toFile(), topic + ".csv");
        String prefix = (String)options.get(PREFIX) + "tamper-evident-";
        String suffix = (String)options.get(SUFFIX);
        FileNamingPolicy fileNamingPolicy = fileNamingPolicyFactory.newFileNamingPolicy(liveFile, suffix, prefix);
        Path keystoreFile = (Path)options.get(KEYSTORE_FILE);
        KeyStoreHandlerDecorator keyStoreHandler = CsvSecureArchiveVerifierCli.getKeyStoreHandlerDecorator(keystoreFile, keystorePassword = (String)options.get(KEYSTORE_PASSWORD));
        if (keyStoreHandler == null) {
            return;
        }
        PublicKey publicKey = CsvSecureArchiveVerifierCli.getSignaturePublicKey(keyStoreHandler);
        if (publicKey == null) {
            return;
        }
        String password = CsvSecureArchiveVerifierCli.getKeystorePassword(keyStoreHandler);
        if (password == null) {
            return;
        }
        CsvSecureArchiveVerifier archiveVerifier = new CsvSecureArchiveVerifier(fileNamingPolicy, password, publicKey, CsvPreference.EXCEL_PREFERENCE);
        List<CsvSecureVerifier.VerificationResult> verificationResults = archiveVerifier.verify();
        CsvSecureArchiveVerifierCli.printVerificationResults(verificationResults, out);
    }

    private static KeyStoreHandlerDecorator getKeyStoreHandlerDecorator(Path keystoreFile, String keystorePassword) {
        try {
            return new KeyStoreHandlerDecorator((KeyStoreHandler)new JcaKeyStoreHandler("JCEKS", keystoreFile.toFile().getAbsolutePath(), keystorePassword));
        }
        catch (Exception e) {
            err.println("Unable to open keystore");
            return null;
        }
    }

    private static PublicKey getSignaturePublicKey(KeyStoreHandlerDecorator keyStoreHandler) {
        try {
            return keyStoreHandler.readPublicKeyFromKeyStore("Signature");
        }
        catch (SecureStorageException e) {
            err.println("Unable to read Signature public key from keystore");
            return null;
        }
    }

    private static String getKeystorePassword(KeyStoreHandlerDecorator keyStoreHandler) {
        try {
            SecretKey passwordKey = keyStoreHandler.readSecretKeyFromKeyStore("Password");
            return Base64.encode((byte[])passwordKey.getEncoded());
        }
        catch (SecureStorageException e) {
            err.println("Unable to read Password secret key from keystore");
            return null;
        }
    }

    static void printVerificationResults(List<CsvSecureVerifier.VerificationResult> verificationResults, PrintStream out) {
        for (CsvSecureVerifier.VerificationResult verificationResult : verificationResults) {
            String filename = verificationResult.getArchiveFile().getName();
            if (verificationResult.hasPassedVerification()) {
                out.println("PASS    " + filename);
                continue;
            }
            out.println("FAIL    " + filename + "    " + verificationResult.getFailureReason());
        }
    }

    private CsvSecureArchiveVerifierCli() {
    }

    static class DefaultFileNamingPolicyFactory
    implements FileNamingPolicyFactory {
        DefaultFileNamingPolicyFactory() {
        }

        @Override
        public FileNamingPolicy newFileNamingPolicy(File liveFile, String suffix, String prefix) {
            return new TimeStampFileNamingPolicy(liveFile, suffix, prefix);
        }
    }

    static interface FileNamingPolicyFactory {
        public FileNamingPolicy newFileNamingPolicy(File var1, String var2, String var3);
    }

    static final class OptionsParser {
        static final String FLAG_ARCHIVE_DIRECTORY = "--archive";
        static final String FLAG_TOPIC = "--topic";
        static final String FLAG_PREFIX = "--prefix";
        static final String FLAG_SUFFIX = "--suffix";
        static final String FLAG_KEYSTORE_FILE = "--keystore";
        static final String FLAG_KEYSTORE_PASSWORD = "--password";
        private static final String DESC_ARCHIVE_DIRECTORY = "path to directory containing files to verify";
        private static final String DESC_TOPIC = "name of topic fileset to verify";
        private static final String DESC_PREFIX = "prefix prepended to archive files";
        private static final String DESC_SUFFIX = "format of timestamp suffix appended to archive files";
        private static final String DESC_KEYSTORE_FILE = "path to keystore file";
        private static final String DESC_KEYSTORE_PASSWORD = "keystore file password";
        private final PrintStream out;
        private final PrintStream err;

        OptionsParser(PrintStream out, PrintStream err) {
            this.out = out;
            this.err = err;
        }

        Options parse(String[] args) {
            Options options = Options.defaultOptions();
            if (args.length == 0) {
                this.printHelp();
                return null;
            }
            HashSet<String> flagsSeen = new HashSet<String>();
            block16: for (int i = 0; i < args.length; i += 2) {
                boolean isLastArgument = args.length == i + 1;
                String currentArgument = args[i];
                if (flagsSeen.contains(currentArgument)) {
                    this.err.println(currentArgument + " should only be provided once");
                    return null;
                }
                flagsSeen.add(currentArgument);
                String nextArgument = isLastArgument ? null : args[i + 1];
                switch (currentArgument) {
                    case "--archive": {
                        options.set(ARCHIVE_DIRECTORY, (Object)this.getPathOption(nextArgument, FLAG_ARCHIVE_DIRECTORY, DESC_ARCHIVE_DIRECTORY));
                        continue block16;
                    }
                    case "--topic": {
                        options.set(TOPIC, (Object)this.getStringOption(nextArgument, FLAG_TOPIC, DESC_TOPIC));
                        continue block16;
                    }
                    case "--prefix": {
                        options.set(PREFIX, (Object)this.getStringOption(nextArgument, FLAG_PREFIX, DESC_PREFIX));
                        continue block16;
                    }
                    case "--suffix": {
                        options.set(SUFFIX, (Object)this.getStringOption(nextArgument, FLAG_SUFFIX, DESC_SUFFIX));
                        continue block16;
                    }
                    case "--keystore": {
                        options.set(KEYSTORE_FILE, (Object)this.getPathOption(nextArgument, FLAG_KEYSTORE_FILE, DESC_KEYSTORE_FILE));
                        continue block16;
                    }
                    case "--password": {
                        options.set(KEYSTORE_PASSWORD, (Object)this.getStringOption(nextArgument, FLAG_KEYSTORE_PASSWORD, DESC_KEYSTORE_PASSWORD));
                        continue block16;
                    }
                    default: {
                        this.err.println("Unknown flag " + currentArgument);
                        return null;
                    }
                }
            }
            if (!flagsSeen.contains(FLAG_ARCHIVE_DIRECTORY) && options.get(ARCHIVE_DIRECTORY) == null) {
                this.err.println("path to directory containing files to verify must be specified using flag --archive");
                return null;
            }
            if (!flagsSeen.contains(FLAG_TOPIC) && options.get(TOPIC) == null) {
                this.err.println("name of topic fileset to verify must be specified using flag --topic");
                return null;
            }
            if (!flagsSeen.contains(FLAG_KEYSTORE_FILE) && options.get(KEYSTORE_FILE) == null) {
                this.err.println("path to keystore file must be specified using flag --keystore");
                return null;
            }
            if (!flagsSeen.contains(FLAG_KEYSTORE_PASSWORD) && options.get(KEYSTORE_PASSWORD) == null) {
                this.err.println("keystore file password must be specified using flag --password");
                return null;
            }
            return options;
        }

        private void printHelp() {
            this.out.println(String.format("arguments: %s <path> %s <topic> [%s <prefix>] [%s <suffix>] %s <path> %s <password>", FLAG_ARCHIVE_DIRECTORY, FLAG_TOPIC, FLAG_PREFIX, FLAG_SUFFIX, FLAG_KEYSTORE_FILE, FLAG_KEYSTORE_PASSWORD));
            this.out.println("");
            this.out.println(String.format("   %-15s %s", FLAG_ARCHIVE_DIRECTORY, DESC_ARCHIVE_DIRECTORY));
            this.out.println(String.format("   %-15s %s", FLAG_TOPIC, DESC_TOPIC));
            this.out.println(String.format("   %-15s %s", FLAG_PREFIX, DESC_PREFIX));
            this.out.println(String.format("   %-15s %s", FLAG_SUFFIX, DESC_SUFFIX));
            this.out.println(String.format("   %-15s %s", FLAG_KEYSTORE_FILE, DESC_KEYSTORE_FILE));
            this.out.println(String.format("   %-15s %s", FLAG_KEYSTORE_PASSWORD, DESC_KEYSTORE_PASSWORD));
        }

        private Path getPathOption(String nextArgument, String flag, String description) {
            if (nextArgument == null) {
                this.err.println(flag + " flag must be followed by " + description);
                return null;
            }
            File file = new File(nextArgument);
            if (!file.exists()) {
                this.err.println(file + " not found");
                return null;
            }
            return file.toPath();
        }

        private String getStringOption(String nextArgument, String flag, String description) {
            if (nextArgument == null) {
                this.err.println(flag + " flag must be followed by " + description);
                return null;
            }
            return nextArgument;
        }
    }
}

