/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxd.rs.protect.resteasy;

import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.log4j.Logger;
import org.gluu.oxauth.client.uma.UmaClientFactory;
import org.gluu.oxauth.client.uma.UmaMetadataService;
import org.gluu.oxauth.client.uma.UmaPermissionService;
import org.gluu.oxauth.client.uma.UmaResourceService;
import org.gluu.oxauth.client.uma.UmaRptIntrospectionService;
import org.gluu.oxauth.client.uma.UmaTokenService;
import org.gluu.oxauth.model.uma.UmaMetadata;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient43Engine;

public class ServiceProvider {
    public static final String WELL_KNOWN_UMA_PATH = "/.well-known/uma2-configuration";
    private static final Logger LOG = Logger.getLogger(ServiceProvider.class);
    private final String opHost;
    private ApacheHttpClient43Engine engine;
    private UmaMetadata umaMetadata = null;
    private UmaTokenService tokenService;
    private UmaMetadataService metadataService = null;
    private UmaResourceService resourceService = null;
    private UmaPermissionService permissionService;
    private UmaRptIntrospectionService rptIntrospectionService;

    public ServiceProvider(String opHost) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        this(opHost, true);
    }

    public ServiceProvider(String opHost, boolean trustAll) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        this(opHost, trustAll ? ServiceProvider.createAcceptSelfSignedCertificateClient() : ServiceProvider.createClient());
    }

    public ServiceProvider(String opHost, HttpClient httpClient) {
        this.opHost = opHost;
        this.engine = new ApacheHttpClient43Engine(httpClient);
    }

    public synchronized UmaRptIntrospectionService getRptIntrospectionService() {
        if (this.rptIntrospectionService == null) {
            this.rptIntrospectionService = UmaClientFactory.instance().createRptStatusService(this.umaMetadata, (ClientHttpEngine)this.engine);
        }
        return this.rptIntrospectionService;
    }

    public synchronized UmaMetadataService getMetadataService() {
        if (this.metadataService == null) {
            this.metadataService = UmaClientFactory.instance().createMetadataService(this.opHost + WELL_KNOWN_UMA_PATH, (ClientHttpEngine)this.engine);
        }
        return this.metadataService;
    }

    public synchronized UmaMetadata getUmaMetadata() {
        if (this.umaMetadata == null) {
            this.umaMetadata = this.getMetadataService().getMetadata();
            LOG.trace((Object)("UMA discovery:" + this.umaMetadata));
        }
        return this.umaMetadata;
    }

    public synchronized UmaResourceService getResourceService() {
        if (this.resourceService == null) {
            this.resourceService = UmaClientFactory.instance().createResourceService(this.getUmaMetadata(), (ClientHttpEngine)this.engine);
        }
        return this.resourceService;
    }

    public synchronized UmaPermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = UmaClientFactory.instance().createPermissionService(this.getUmaMetadata(), (ClientHttpEngine)this.engine);
        }
        return this.permissionService;
    }

    public synchronized UmaTokenService getTokenService() {
        if (this.tokenService == null) {
            this.tokenService = UmaClientFactory.instance().createTokenService(this.getUmaMetadata(), (ClientHttpEngine)this.engine);
        }
        return this.tokenService;
    }

    public String getOpHost() {
        return this.opHost;
    }

    public String opHostWithoutProtocol() {
        if (StringUtils.contains((String)this.opHost, (String)"//")) {
            return StringUtils.substringAfter((String)this.opHost, (String)"//");
        }
        return this.opHost;
    }

    public ApacheHttpClient43Engine getClientEngine() {
        return this.engine;
    }

    private static HttpClient createClient() {
        return ServiceProvider.createClient(null);
    }

    private static HttpClient createAcceptSelfSignedCertificateClient() throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        SSLConnectionSocketFactory connectionFactory = ServiceProvider.createAcceptSelfSignedSocketFactory();
        return ServiceProvider.createClient(connectionFactory);
    }

    private static HttpClient createClient(SSLConnectionSocketFactory connectionFactory) {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        HttpClientBuilder httClientBuilder = HttpClients.custom();
        if (connectionFactory != null) {
            httClientBuilder = httClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)connectionFactory);
        }
        CloseableHttpClient httpClient = httClientBuilder.setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("standard").build()).setConnectionManager((HttpClientConnectionManager)cm).build();
        cm.setMaxTotal(200);
        cm.setDefaultMaxPerRoute(20);
        return httpClient;
    }

    private static SSLConnectionSocketFactory createAcceptSelfSignedSocketFactory() throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException {
        SSLContext sslContext = SSLContextBuilder.create().loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy()).build();
        NoopHostnameVerifier allowAllHosts = new NoopHostnameVerifier();
        SSLConnectionSocketFactory connectionFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)allowAllHosts);
        return connectionFactory;
    }
}

