/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxd.rs.protect.resteasy;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.gluu.oxauth.model.uma.PermissionTicket;
import org.gluu.oxauth.model.uma.RptIntrospectionResponse;
import org.gluu.oxauth.model.uma.UmaPermission;
import org.gluu.oxauth.model.uma.UmaPermissionList;
import org.gluu.oxd.rs.protect.Jackson;
import org.gluu.oxd.rs.protect.resteasy.Key;
import org.gluu.oxd.rs.protect.resteasy.PatProvider;
import org.gluu.oxd.rs.protect.resteasy.ResourceRegistrar;
import org.gluu.oxd.rs.protect.resteasy.ServiceProvider;
import org.gluu.util.StringHelper;
import org.jboss.resteasy.client.ClientResponseFailure;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.core.ServerResponse;
import org.jboss.resteasy.specimpl.BuiltResponse;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.interception.PreProcessInterceptor;

public class RptPreProcessInterceptor
implements PreProcessInterceptor {
    private static final Logger LOG = Logger.getLogger(RptPreProcessInterceptor.class);
    private final ResourceRegistrar resourceRegistrar;
    private final PatProvider patProvider;
    private final ServiceProvider serviceProvider;

    public RptPreProcessInterceptor(ResourceRegistrar resourceRegistrar) {
        Preconditions.checkNotNull((Object)resourceRegistrar, (Object)"Resource registrar is null.");
        Preconditions.checkNotNull((Object)resourceRegistrar.getPatProvider(), (Object)"PAT Provider is null.");
        Preconditions.checkNotNull((Object)resourceRegistrar.getServiceProvider(), (Object)"Service Provider is null.");
        this.resourceRegistrar = resourceRegistrar;
        this.patProvider = resourceRegistrar.getPatProvider();
        this.serviceProvider = resourceRegistrar.getServiceProvider();
    }

    public ServerResponse preProcess(HttpRequest request, ResourceMethodInvoker invoker) throws Failure, WebApplicationException {
        String httpMethod;
        String path = this.getPath(request);
        Key key = this.resourceRegistrar.getKey(path, httpMethod = request.getHttpMethod());
        if (key == null) {
            LOG.debug((Object)("Resource is not protected with UMA, path:" + path + ", httpMethod: " + httpMethod));
            return null;
        }
        try {
            String rpt = RptPreProcessInterceptor.getRpt(request.getHttpHeaders());
            if (!Strings.isNullOrEmpty((String)rpt)) {
                LOG.debug((Object)"RPT present in request");
                RptIntrospectionResponse status = this.requestRptStatus(rpt);
                if (this.hasPermission(status, key, httpMethod, RptPreProcessInterceptor.isGat(rpt))) {
                    LOG.debug((Object)("RPT has enough permissions, access GRANTED. Path: " + path + ", httpMethod:" + httpMethod));
                    return null;
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            if (e instanceof ClientResponseFailure) {
                LOG.error((Object)("Entity: " + ((ClientResponseFailure)((Object)e)).getResponse().getEntity(String.class)));
            }
            return new ServerResponse((BuiltResponse)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build());
        }
        LOG.debug((Object)"Client does not present valid RPT. Registering permission ticket ...");
        return new ServerResponse((BuiltResponse)this.registerTicketResponse(path, httpMethod));
    }

    public static boolean isGat(String rpt) {
        return !Strings.isNullOrEmpty((String)rpt) && rpt.startsWith("gat_");
    }

    public boolean hasPermission(RptIntrospectionResponse status, Key key, String httpMethod, boolean isGat) {
        if (status != null && status.getActive()) {
            String resourceSetId = this.resourceRegistrar.getResourceSetId(key);
            if (Strings.isNullOrEmpty((String)resourceSetId)) {
                LOG.error((Object)("Resource has key but is not registered on AS. Key: " + key));
                return false;
            }
            if (status.getPermissions() != null) {
                for (UmaPermission permission : status.getPermissions()) {
                    if (permission.getResourceId() != null && permission.getResourceId().equals(resourceSetId) && this.resourceRegistrar.getProtector().hasAccess(key.getPath(), httpMethod, permission.getScopes())) {
                        return true;
                    }
                    if (!isGat || !this.resourceRegistrar.getProtector().hasAccess(key.getPath(), httpMethod, permission.getScopes())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public String getPath(HttpRequest request) {
        if (request.getUri() != null && request.getUri().getAbsolutePath() != null) {
            return request.getUri().getAbsolutePath().getPath();
        }
        return null;
    }

    public static String getRptFromAuthorization(String authorizationHeader) {
        if (StringHelper.isNotEmpty((String)authorizationHeader) && authorizationHeader.startsWith("Bearer ")) {
            return authorizationHeader.substring("Bearer ".length());
        }
        return null;
    }

    public static String getRpt(HttpHeaders httpHeaders) {
        List authHeaders;
        if (httpHeaders != null && (authHeaders = httpHeaders.getRequestHeader("Authorization")) != null && !authHeaders.isEmpty()) {
            String authorization = (String)authHeaders.get(0);
            return RptPreProcessInterceptor.getRptFromAuthorization(authorization);
        }
        return "";
    }

    public RptIntrospectionResponse requestRptStatus(String rpt) {
        if (StringUtils.isNotBlank((String)rpt)) {
            LOG.debug((Object)("Request RPT " + rpt + " status..."));
            RptIntrospectionResponse status = this.serviceProvider.getRptIntrospectionService().requestRptStatus("Bearer " + this.patProvider.getPatToken(), rpt, "");
            if (status != null) {
                LOG.debug((Object)("RPT status: " + Jackson.asJsonSilently((Object)status)));
                return status;
            }
            LOG.debug((Object)("Unable to retrieve RPT " + rpt + " status from AM."));
        }
        return null;
    }

    public Response registerTicketResponse(String path, String httpMethod) {
        Key key = this.resourceRegistrar.getKey(path, httpMethod);
        if (key == null) {
            LOG.error((Object)("Resource is not registered. Path: " + path + ", httpMethod: " + httpMethod + ". Please register it via uma-rs configuration."));
            LOG.error((Object)"Skip protection !!!");
            return null;
        }
        List ticketScopes = this.resourceRegistrar.getRsResource(key).getScopesForTicket(httpMethod);
        LOG.trace((Object)("Ticket scopes: " + ticketScopes));
        return this.registerTicketResponse(ticketScopes, this.resourceRegistrar.getResourceSetId(key));
    }

    public Response registerTicketResponse(List<String> scopes, String resourceSetId) {
        return this.registerTicketResponse(scopes, resourceSetId, true);
    }

    public Response registerTicketResponse(List<String> scopes, String resourceSetId, boolean retry) {
        Preconditions.checkState((scopes != null && !scopes.isEmpty() ? 1 : 0) != 0, (Object)"Scopes must not be empty.");
        Preconditions.checkState((!Strings.isNullOrEmpty((String)resourceSetId) ? 1 : 0) != 0, (Object)"ResourceId must be set.");
        try {
            UmaPermission permission = new UmaPermission();
            permission.setResourceId(resourceSetId);
            permission.setScopes(scopes);
            PermissionTicket ticket = this.resourceRegistrar.getServiceProvider().getPermissionService().registerPermission("Bearer " + this.patProvider.getPatToken(), UmaPermissionList.instance((UmaPermission[])new UmaPermission[]{permission}));
            if (ticket != null) {
                String headerValue = "UMA realm=\"rs\",as_uri=\"" + this.serviceProvider.getOpHost() + "\",error=\"insufficient_scope\",ticket=\"" + ticket.getTicket() + "\"";
                LOG.debug((Object)("Ticket registered, " + headerValue));
                return Response.status((Response.Status)Response.Status.FORBIDDEN).header("WWW-Authenticate", (Object)headerValue).entity((Object)ticket).build();
            }
            LOG.error((Object)"Failed to register permission ticket. Response is null.");
        }
        catch (ClientResponseFailure e) {
            LOG.debug((Object)("Failed to register ticket. Entity: " + e.getResponse().getEntity(String.class) + ", status: " + e.getResponse().getStatus()), (Throwable)e);
            if (e.getResponse().getStatus() == 400 || e.getResponse().getStatus() == 401) {
                LOG.debug((Object)"Try maybe PAT is lost on AS, force refresh PAT and request ticket again ...");
                this.patProvider.clearPat();
                if (retry) {
                    LOG.debug((Object)"Re-try register the ticket.");
                    return this.registerTicketResponse(scopes, resourceSetId, false);
                }
            }
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to register permission ticket.", (Throwable)e);
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).header("Warning:", (Object)"UMA Authorization Server Unreachable").build();
    }
}

