/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxd.rs.protect.resteasy;

import com.google.common.base.Preconditions;
import org.apache.log4j.Logger;
import org.gluu.oxauth.client.TokenClient;
import org.gluu.oxauth.client.TokenResponse;
import org.gluu.oxauth.model.uma.UmaMetadata;
import org.gluu.oxauth.model.uma.UmaScopeType;
import org.gluu.oxauth.model.uma.wrapper.Token;
import org.gluu.oxauth.model.util.Util;
import org.gluu.oxd.rs.protect.resteasy.Configuration;
import org.gluu.oxd.rs.protect.resteasy.PatProvider;
import org.gluu.oxd.rs.protect.resteasy.ServiceProvider;

public class ObtainPatProvider
implements PatProvider {
    private static final Logger LOG = Logger.getLogger(PatProvider.class);
    private final ServiceProvider serviceProvider;
    private final Configuration configuration;
    private Token patToken;

    public ObtainPatProvider(ServiceProvider serviceProvider, Configuration configuration) {
        this.serviceProvider = serviceProvider;
        this.configuration = configuration;
    }

    @Override
    public synchronized String getPatToken() {
        if (this.patToken == null) {
            this.obtainPat();
        }
        Preconditions.checkNotNull((Object)this.patToken);
        return this.patToken.getAccessToken();
    }

    @Override
    public synchronized void clearPat() {
        this.patToken = null;
        LOG.trace((Object)"Cleared PAT.");
    }

    public String renewPat() {
        this.clearPat();
        return this.getPatToken();
    }

    private void obtainPat() {
        try {
            UmaMetadata umaMetadata = this.serviceProvider.getUmaMetadata();
            this.patToken = this.requestPat(umaMetadata.getTokenEndpoint(), this.configuration.getUmaPatClientId(), this.configuration.getUmaPatClientSecret(), new String[0]);
            LOG.trace((Object)"New PAT obtained.");
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to obtain PAT. " + e.getMessage()), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public ServiceProvider getServiceProvider() {
        return this.serviceProvider;
    }

    public Token requestPat(String tokenUrl, String umaClientId, String umaClientSecret, String ... scopeArray) throws Exception {
        String scope = UmaScopeType.PROTECTION.getValue();
        if (scopeArray != null && scopeArray.length > 0) {
            for (String s : scopeArray) {
                scope = scope + " " + s;
            }
        }
        TokenClient tokenClient = new TokenClient(tokenUrl);
        tokenClient.setExecutor(this.serviceProvider.getClientExecutor());
        TokenResponse response = tokenClient.execClientCredentialsGrant(scope, umaClientId, umaClientSecret);
        if (response.getStatus() == 200) {
            String patToken = response.getAccessToken();
            Integer expiresIn = response.getExpiresIn();
            if (Util.allNotBlank((String[])new String[]{patToken})) {
                return new Token(null, null, patToken, UmaScopeType.PROTECTION.getValue(), expiresIn);
            }
        }
        return null;
    }
}

