/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.radius.util;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;

public class ThreadUtil {
    private static ThreadGroup rootGroup = null;

    public static final Thread findRunningThread(String name) {
        Thread[] threads;
        if (name == null) {
            return null;
        }
        for (Thread thread : threads = ThreadUtil.getAllThreads(Thread.State.RUNNABLE)) {
            if (!thread.getName().equalsIgnoreCase(name)) continue;
            return thread;
        }
        return null;
    }

    private static final Thread[] getAllThreads(Thread.State state) {
        Thread[] threads;
        ThreadUtil.initRootThreadGroup();
        ThreadMXBean thBean = ManagementFactory.getThreadMXBean();
        int allocsize = thBean.getThreadCount();
        int n = 0;
        while ((n = rootGroup.enumerate(threads = new Thread[allocsize *= 2], true)) == allocsize) {
        }
        return Arrays.copyOf(threads, n);
    }

    private static final void initRootThreadGroup() {
        if (rootGroup != null) {
            return;
        }
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        ThreadGroup ptg = null;
        while ((ptg = tg.getParent()) != null) {
            tg = ptg;
        }
        rootGroup = tg;
    }
}

