/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.radius.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.log4j.Logger;

public class NetUtil {
    private static final Logger log = Logger.getLogger(NetUtil.class);
    private static final Short[][] cidrSubnets = new Short[][]{{(short)0, (short)0, (short)0, (short)0}, {(short)128, (short)0, (short)0, (short)0}, {(short)192, (short)0, (short)0, (short)0}, {(short)224, (short)0, (short)0, (short)0}, {(short)240, (short)0, (short)0, (short)0}, {(short)248, (short)0, (short)0, (short)0}, {(short)252, (short)0, (short)0, (short)0}, {(short)254, (short)0, (short)0, (short)0}, {(short)255, (short)0, (short)0, (short)0}, {(short)255, (short)128, (short)0, (short)0}, {(short)255, (short)192, (short)0, (short)0}, {(short)255, (short)224, (short)0, (short)0}, {(short)255, (short)240, (short)0, (short)0}, {(short)255, (short)248, (short)0, (short)0}, {(short)255, (short)252, (short)0, (short)0}, {(short)255, (short)254, (short)0, (short)0}, {(short)255, (short)255, (short)0, (short)0}, {(short)255, (short)255, (short)128, (short)0}, {(short)255, (short)255, (short)192, (short)0}, {(short)255, (short)255, (short)224, (short)0}, {(short)255, (short)255, (short)240, (short)0}, {(short)255, (short)255, (short)248, (short)0}, {(short)255, (short)255, (short)252, (short)0}, {(short)255, (short)255, (short)254, (short)0}, {(short)255, (short)255, (short)255, (short)0}, {(short)255, (short)255, (short)255, (short)128}, {(short)255, (short)255, (short)255, (short)192}, {(short)255, (short)255, (short)255, (short)224}, {(short)255, (short)255, (short)255, (short)240}, {(short)255, (short)255, (short)255, (short)248}, {(short)255, (short)255, (short)255, (short)252}, {(short)255, (short)255, (short)255, (short)254}, {(short)255, (short)255, (short)255, (short)255}};
    private static Pattern ipPattern;
    private static Pattern subnetPattern;

    public static final boolean isValidIpAddress(String ipAddress) {
        if (ipAddress == null) {
            return false;
        }
        return ipPattern.matcher(ipAddress).matches();
    }

    public static final boolean isValidSubnetCidrNotiation(String subnetNotation) {
        if (subnetNotation == null) {
            return false;
        }
        return subnetPattern.matcher(subnetNotation).matches();
    }

    public static final boolean ipAddressBelongsToSubnet(String ipAddress, String subnetNotation) {
        if (ipAddress == null || subnetNotation == null) {
            return false;
        }
        try {
            Matcher ipmatcher = ipPattern.matcher(ipAddress);
            if (!ipmatcher.matches()) {
                log.debug((Object)String.format("{%s} is not a valid ip address", ipAddress));
                return false;
            }
            Matcher subnetmatcher = subnetPattern.matcher(subnetNotation);
            if (!subnetmatcher.matches()) {
                log.debug((Object)String.format("{%s} is not valid is not a valid CIDR subnet notation", subnetNotation));
                return false;
            }
            IpNotation ip = new IpNotation(ipmatcher);
            SubnetNotation subnet = new SubnetNotation(subnetmatcher);
            return subnet.addressInRange(ip);
        }
        catch (NumberFormatException e) {
            log.debug((Object)"Could not parse ip address or subnet", (Throwable)e);
            return false;
        }
    }

    static {
        try {
            ipPattern = Pattern.compile("^([0-9]{1,3})\\.([0-9]{1,3})\\.([0-9]{1,3})\\.([0-9]{1,3})$");
            subnetPattern = Pattern.compile("^([0-9]{1,3})\\.([0-9]{1,3})\\.([0-9]{1,3})\\.([0-9]{1,3})/([0-9]{2})$");
        }
        catch (PatternSyntaxException e) {
            log.debug((Object)"Invalid regex pattern syntax detected", (Throwable)e);
        }
    }

    private static class SubnetNotation {
        public IpNotation network;
        public IpNotation subnet;

        public SubnetNotation(Matcher matcher) {
            try {
                this.network = new IpNotation(matcher);
                this.subnet = new IpNotation(Short.parseShort(matcher.group(5)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public final boolean isValid() {
            return this.network != null && this.network.isValid() && this.subnet != null && this.subnet.isValid();
        }

        public final boolean addressInRange(IpNotation ip) {
            if (ip == null || !this.isValid()) {
                return false;
            }
            return Short.compare((short)(ip.firstByte & this.subnet.firstByte), this.network.firstByte) == 0 && Short.compare((short)(ip.secondByte & this.subnet.secondByte), this.network.secondByte) == 0 && Short.compare((short)(ip.thirdByte & this.subnet.thirdByte), this.network.thirdByte) == 0 && Short.compare((short)(ip.fourthByte & this.subnet.fourthByte), this.network.fourthByte) == 0;
        }
    }

    private static class IpNotation {
        public Short firstByte;
        public Short secondByte;
        public Short thirdByte;
        public Short fourthByte;

        public IpNotation(Matcher ipmatcher) {
            try {
                this.firstByte = Short.parseShort(ipmatcher.group(1));
                this.secondByte = Short.parseShort(ipmatcher.group(2));
                this.thirdByte = Short.parseShort(ipmatcher.group(3));
                this.fourthByte = Short.parseShort(ipmatcher.group(4));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public IpNotation(Short subnet) {
            if (subnet >= 0 && subnet <= 32) {
                this.firstByte = cidrSubnets[subnet][0];
                this.secondByte = cidrSubnets[subnet][1];
                this.thirdByte = cidrSubnets[subnet][2];
                this.fourthByte = cidrSubnets[subnet][3];
            }
        }

        public final boolean isValid() {
            return this.firstByte != null && this.secondByte != null && this.thirdByte != null && this.fourthByte != null;
        }
    }
}

