/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.radius.util;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.gluu.radius.exception.GluuRadiusException;

public class EncDecUtil {
    private static final String CHARSET_ENCODING = "UTF-8";
    private static final Integer BLOCK_SIZE = 8;
    private static final Integer KEY_SIZE = 24;
    private static final String ALGORITHM_NAME = "DESede";
    private static final String CIPHER_TRANSFORMATION = "DESede/ECB/PKCS5Padding";

    private static final SecretKeySpec generateTripleDesSecretKeySpec(String encryptionkey) {
        if (encryptionkey == null) {
            throw new GluuRadiusException("null encryption key ");
        }
        try {
            byte[] keybytes = encryptionkey.getBytes(CHARSET_ENCODING);
            return new SecretKeySpec(keybytes, ALGORITHM_NAME);
        }
        catch (UnsupportedEncodingException e) {
            throw new GluuRadiusException("unsupported encoding for encryption key", e);
        }
    }

    public static final String encode(String data, String salt) {
        if (data == null) {
            throw new GluuRadiusException("Plaintext data cannot be null");
        }
        if (salt == null) {
            throw new GluuRadiusException("encryption key cannot be null");
        }
        try {
            SecretKeySpec keyspec = EncDecUtil.generateTripleDesSecretKeySpec(salt);
            Cipher cipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
            cipher.init(1, keyspec);
            byte[] encrypted = cipher.doFinal(data.getBytes(CHARSET_ENCODING));
            return Base64.encodeBase64String((byte[])encrypted);
        }
        catch (NoSuchAlgorithmException e) {
            throw new GluuRadiusException("data encoding failed", e);
        }
        catch (NoSuchPaddingException e) {
            throw new GluuRadiusException("data encoding failed", e);
        }
        catch (InvalidKeyException e) {
            throw new GluuRadiusException("data encoding failed", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new GluuRadiusException("data encoding failed", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new GluuRadiusException("data encoding failed", e);
        }
        catch (BadPaddingException e) {
            throw new GluuRadiusException("data encoding failed", e);
        }
    }

    public static final String decode(String data, String salt) {
        if (data == null) {
            throw new GluuRadiusException("data cannot be null");
        }
        if (salt == null) {
            throw new GluuRadiusException("data cannot be null");
        }
        try {
            byte[] binarydata = Base64.decodeBase64((String)data);
            SecretKeySpec keyspec = EncDecUtil.generateTripleDesSecretKeySpec(salt);
            Cipher cipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
            cipher.init(2, keyspec);
            byte[] decoded = cipher.doFinal(binarydata);
            return new String(decoded, CHARSET_ENCODING);
        }
        catch (IndexOutOfBoundsException e) {
            throw new GluuRadiusException("data decoding failed", e);
        }
        catch (ArrayStoreException e) {
            throw new GluuRadiusException("data decoding failed", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new GluuRadiusException("data decoding failed", e);
        }
        catch (NoSuchPaddingException e) {
            throw new GluuRadiusException("data decoding failed", e);
        }
        catch (InvalidKeyException e) {
            throw new GluuRadiusException("data decoding failed", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new GluuRadiusException("data decoding failed", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new GluuRadiusException("data decoding failed", e);
        }
        catch (BadPaddingException e) {
            throw new GluuRadiusException("data decoding failed", e);
        }
    }
}

