/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.radius.service;

import java.util.ArrayList;
import java.util.List;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.persist.exception.EntryPersistenceException;
import org.gluu.radius.exception.ServiceException;
import org.gluu.radius.model.AuthScope;
import org.gluu.radius.model.ServerConfiguration;

public class ServerConfigService {
    private String configEntryDn;
    private PersistenceEntryManager persistenceEntryManager;

    public ServerConfigService(PersistenceEntryManager persistenceEntryManager, String configEntryDn) {
        this.persistenceEntryManager = persistenceEntryManager;
        this.configEntryDn = configEntryDn;
    }

    public ServerConfiguration getServerConfiguration() {
        try {
            return (ServerConfiguration)this.persistenceEntryManager.find(ServerConfiguration.class, (Object)this.configEntryDn);
        }
        catch (EntryPersistenceException e) {
            throw new ServiceException("Failed fetching server configuration", e);
        }
    }

    public List<AuthScope> getScopes(ServerConfiguration config) {
        ArrayList<AuthScope> ret = new ArrayList<AuthScope>();
        try {
            for (String scopeDn : config.getScopes()) {
                AuthScope scope = (AuthScope)this.persistenceEntryManager.find(AuthScope.class, (Object)scopeDn);
                if (scope == null) continue;
                ret.add(scope);
            }
        }
        catch (EntryPersistenceException e) {
            throw new ServiceException("Failed fetch associated scopes for server configuration", e);
        }
        return ret;
    }
}

