/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.radius.service;

import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.PrivateKey;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;
import org.bouncycastle.openssl.PEMEncryptor;
import org.bouncycastle.openssl.jcajce.JcaMiscPEMGenerator;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.openssl.jcajce.JcePEMEncryptorBuilder;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.gluu.oxauth.client.supergluu.impl.ICryptoProviderFactory;
import org.gluu.oxauth.model.crypto.AbstractCryptoProvider;
import org.gluu.oxauth.model.crypto.OxAuthCryptoProvider;
import org.gluu.oxauth.model.crypto.encryption.KeyEncryptionAlgorithm;
import org.gluu.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.gluu.oxauth.model.jwk.Algorithm;
import org.gluu.oxauth.model.jwk.JSONWebKey;
import org.gluu.oxauth.model.jwk.JSONWebKeySet;
import org.gluu.oxauth.model.jwk.KeyType;
import org.gluu.oxauth.model.jwk.Use;
import org.gluu.oxauth.model.util.StringUtils;
import org.gluu.radius.service.BootstrapConfigService;
import org.json.JSONArray;
import org.json.JSONObject;

public class CryptoService
implements ICryptoProviderFactory {
    private static final Logger log = Logger.getLogger(CryptoService.class);
    private static final String dnName = "CN=Gluu Radius CA Certificates";
    private static final String PRIVATE_KEY_ENC_ALGORITHM = "AES-256-CBC";
    private static final String PRIVATE_KEY_FILENAME = "/gluu-radius.private-key.pem";
    private BootstrapConfigService bcService;
    private JSONObject serverKeyset;
    private OxAuthCryptoProvider cryptoProvider;
    private List<Algorithm> signAlgorithms;
    private int expiration;
    private int expiration_hours;
    private String authSigningKeyId;
    private ReadWriteLock cryptoLock;

    public CryptoService(BootstrapConfigService bcService, List<Algorithm> signAlgorithms, int expiration, int expiration_hours) throws Exception {
        this.bcService = bcService;
        this.signAlgorithms = signAlgorithms;
        this.expiration = expiration;
        this.expiration_hours = expiration_hours;
        this.serverKeyset = new JSONObject();
        this.serverKeyset.put("keys", (Object)new JSONArray());
        String keyStoreFile = bcService.getJwtKeyStoreFile();
        String keyStorePin = bcService.getJwtKeyStorePin();
        this.authSigningKeyId = bcService.getJwtAuthKeyId();
        this.cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStorePin, dnName);
        SignatureAlgorithm signalgo = bcService.getJwtAuthSignAlgo();
        Algorithm algo = Algorithm.fromString((String)signalgo.getName());
        this.authSigningKeyId = this.cryptoProvider.getAliasByAlgorithmForDeletion(algo, "", Use.SIGNATURE);
        log.info((Object)String.format("Auth signing keyId: %s", this.authSigningKeyId));
        this.cryptoLock = new ReentrantReadWriteLock();
    }

    public JSONObject getServerKeyset() {
        return this.serverKeyset;
    }

    public void setServerKeyset(JSONObject serverKeyset) {
        this.serverKeyset = serverKeyset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractCryptoProvider getCryptoProvider() {
        OxAuthCryptoProvider oxAuthCryptoProvider = this.cryptoProvider;
        synchronized (oxAuthCryptoProvider) {
            return this.cryptoProvider;
        }
    }

    public AbstractCryptoProvider newCryptoProvider() {
        return this.getCryptoProvider();
    }

    public String getAuthSigningKeyId() {
        return this.authSigningKeyId;
    }

    public final void beginReadOpts() {
        this.cryptoLock.readLock().lock();
    }

    public final void endReadOpts() {
        this.cryptoLock.readLock().unlock();
    }

    public final void beginWriteOpts() {
        this.cryptoLock.writeLock().lock();
    }

    public final void endWriteOpts() {
        this.cryptoLock.writeLock().unlock();
    }

    public PrivateKey getAuthenticationPrivateKey() throws Exception {
        return this.cryptoProvider.getPrivateKey(this.authSigningKeyId);
    }

    public JSONWebKeySet generateKeys() throws Exception {
        JSONWebKeySet keyset = new JSONWebKeySet();
        GregorianCalendar calendar = new GregorianCalendar();
        ((Calendar)calendar).add(5, this.expiration);
        ((Calendar)calendar).add(10, this.expiration_hours);
        for (Algorithm algorithm : this.signAlgorithms) {
            JSONWebKey key = this.generateKey(calendar, algorithm, Use.SIGNATURE);
            SignatureAlgorithm signalgo = SignatureAlgorithm.fromString((String)algorithm.name());
            if (this.bcService.getJwtAuthSignAlgo() == signalgo) {
                this.authSigningKeyId = key.getKid();
            }
            keyset.getKeys().add(key);
            String oldkey = this.cryptoProvider.getAliasByAlgorithmForDeletion(algorithm, key.getKid(), Use.SIGNATURE);
            if (oldkey == null) continue;
            this.cryptoProvider.deleteKey(oldkey);
        }
        return keyset;
    }

    public void exportAuthPrivateKeyToPem() throws Exception {
        File keystorefile = new File(this.bcService.getJwtKeyStoreFile());
        String parentdir = keystorefile.getParent();
        if (parentdir != null) {
            File pkeyfile = new File(parentdir + PRIVATE_KEY_FILENAME);
            this.exportAuthPrivateKeyToPem(pkeyfile);
        }
    }

    public void exportAuthPrivateKeyToPem(File outfile) throws Exception {
        this.exportAuthPrivateKeyToPem(outfile, this.bcService.getJwtKeyStorePin());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportAuthPrivateKeyToPem(File outfile, String passphrase) throws Exception {
        OutputStreamWriter filewriter = null;
        JcaPEMWriter pemwriter = null;
        try {
            if (!outfile.canWrite()) {
                log.warn((Object)String.format("The private key file %s is not writable.", outfile.getAbsolutePath()));
                return;
            }
            PEMEncryptor encryptor = new JcePEMEncryptorBuilder(PRIVATE_KEY_ENC_ALGORITHM).build(passphrase.toCharArray());
            PrivateKey privatekey = this.cryptoProvider.getPrivateKey(this.authSigningKeyId);
            JcaMiscPEMGenerator pemgenerator = new JcaMiscPEMGenerator((Object)privatekey, encryptor);
            filewriter = new FileWriter(outfile);
            pemwriter = new JcaPEMWriter((Writer)filewriter);
            pemwriter.writeObject((PemObjectGenerator)pemgenerator);
        }
        finally {
            if (pemwriter != null) {
                pemwriter.close();
            }
            if (filewriter != null) {
                filewriter.close();
            }
        }
    }

    private final JSONWebKey generateKey(Calendar expirytime, Algorithm algo, Use use) throws Exception {
        JSONObject result = this.cryptoProvider.generateKey(algo, Long.valueOf(expirytime.getTimeInMillis()), use);
        JSONWebKey key = new JSONWebKey();
        key.setKid(result.getString("kid"));
        key.setUse(use);
        key.setAlg(algo);
        if (use == Use.SIGNATURE) {
            SignatureAlgorithm signalgo = SignatureAlgorithm.fromString((String)algo.name());
            key.setKty(KeyType.fromString((String)signalgo.getFamily().toString()));
            key.setCrv(signalgo.getCurve());
        } else if (use == Use.ENCRYPTION) {
            KeyEncryptionAlgorithm encalgo = KeyEncryptionAlgorithm.fromName((String)algo.name());
            key.setKty(KeyType.fromString((String)encalgo.getFamily()));
        }
        key.setExp(Long.valueOf(result.optLong("exp")));
        key.setN(result.optString("n"));
        key.setE(result.optString("e"));
        key.setX(result.optString("x"));
        key.setY(result.optString("y"));
        JSONArray x5c = result.optJSONArray("x5c");
        key.setX5c(StringUtils.toList((JSONArray)x5c));
        return key;
    }
}

