/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.radius.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.gluu.orm.util.properties.FileConfiguration;
import org.gluu.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.gluu.persist.model.PersistenceConfiguration;
import org.gluu.radius.exception.ServiceException;
import org.gluu.radius.util.EncDecUtil;
import org.gluu.util.security.PropertiesDecrypter;
import org.gluu.util.security.StringEncrypter;

public class BootstrapConfigService {
    private static final String encodeSaltKey = "encodeSalt";
    private static final Logger LOG = Logger.getLogger(BootstrapConfigService.class);
    private boolean listenEnabled;
    private AuthScheme scheme;
    private String salt;
    private Properties persistenceConfig;
    private String persistenceConfigFile;
    private String jwtKeyStoreFile;
    private String jwtKeyStorePin;
    private String jwtAuthKeyId;
    private Long keygenInterval;
    private SignatureAlgorithm jwtAuthSignAlgo;
    private String configDN;
    private String clientsDN;
    private String openidClientsDN;

    public BootstrapConfigService(String appConfigFile) {
        Properties oxRadiusConfig = this.loadPropertiesFromFile(appConfigFile);
        String listen = oxRadiusConfig.getProperty(BootstrapConfigKeys.ListenEnable.getKeyName());
        if (listen == null) {
            throw new ServiceException("Server listening status not specified.");
        }
        listen.trim();
        if (listen.equalsIgnoreCase("true")) {
            this.listenEnabled = true;
        } else if (listen.equalsIgnoreCase("false")) {
            this.listenEnabled = false;
        } else {
            throw new ServiceException("Invalid value for property radius.listen.enable.");
        }
        String authscheme = oxRadiusConfig.getProperty(BootstrapConfigKeys.AuthScheme.getKeyName());
        if (authscheme == null) {
            throw new ServiceException("Unspecified authentication scheme");
        }
        if ((authscheme = authscheme.trim()).equalsIgnoreCase("onestep")) {
            this.scheme = AuthScheme.ONE_STEP_AUTH;
        } else if (authscheme.equalsIgnoreCase("twostep")) {
            this.scheme = AuthScheme.TWO_STEP_AUTH;
        } else {
            throw new ServiceException("Invalid/Unknown authscheme specified in configuration.");
        }
        String saltFile = oxRadiusConfig.getProperty(BootstrapConfigKeys.SaltFile.getKeyName());
        if (saltFile == null) {
            throw new ServiceException("Salt file not found");
        }
        saltFile = saltFile.trim();
        this.salt = this.loadEncodeSalt(saltFile);
        this.persistenceConfigFile = oxRadiusConfig.getProperty(BootstrapConfigKeys.PersistenceConfigFile.getKeyName());
        File persistFileObj = new File(this.persistenceConfigFile);
        if (!persistFileObj.exists()) {
            throw new ServiceException("Persistence configuration file not found");
        }
        this.persistenceConfig = this.loadPropertiesFromFile(this.persistenceConfigFile);
        this.jwtKeyStorePin = oxRadiusConfig.getProperty(BootstrapConfigKeys.JwtKeyStorePin.getKeyName());
        this.jwtKeyStorePin = EncDecUtil.decode(this.jwtKeyStorePin, this.salt);
        this.jwtKeyStoreFile = oxRadiusConfig.getProperty(BootstrapConfigKeys.JwtKeyStoreFile.getKeyName());
        String signalgo = oxRadiusConfig.getProperty(BootstrapConfigKeys.JwtAuthSignatureAlgorithm.getKeyName());
        this.jwtAuthSignAlgo = SignatureAlgorithm.fromString((String)signalgo);
        this.jwtAuthKeyId = oxRadiusConfig.getProperty(BootstrapConfigKeys.JwtAuthKeyId.getKeyName());
        String krinterval = oxRadiusConfig.getProperty(BootstrapConfigKeys.JwtKeyGenInterval.getKeyName());
        try {
            this.keygenInterval = Long.parseLong(krinterval);
            if (this.keygenInterval < 0L) {
                throw new ServiceException("Keygen interval lesser than 0.");
            }
        }
        catch (NumberFormatException e) {
            throw new ServiceException("Invalid value for keygen interval.");
        }
        this.configDN = this.persistenceConfig.getProperty(BootstrapConfigKeys.ConfigDN.getKeyName());
        if (this.configDN == null) {
            throw new ServiceException("Server configuration base DN missing from configuration.");
        }
        this.clientsDN = oxRadiusConfig.getProperty(BootstrapConfigKeys.ClientsDN.getKeyName());
        if (this.clientsDN == null) {
            throw new ServiceException("Radius clients base DN missing from configuration.");
        }
        this.openidClientsDN = oxRadiusConfig.getProperty(BootstrapConfigKeys.OpenIdClientsDN.getKeyName());
        if (this.openidClientsDN == null) {
            throw new ServiceException("OpenID clients base DN missing from configuration.");
        }
    }

    public final String getEncodeSalt() {
        return this.salt;
    }

    public final boolean isListenEnabled() {
        return this.listenEnabled;
    }

    public final boolean isOneStepAuth() {
        return this.scheme == AuthScheme.ONE_STEP_AUTH;
    }

    public final boolean isTwoStepAuth() {
        return this.scheme == AuthScheme.TWO_STEP_AUTH;
    }

    public final String getRadiusConfigDN() {
        return this.configDN;
    }

    public final String getRadiusClientConfigDN() {
        return this.clientsDN;
    }

    public final String getOpenidClientsDN() {
        return this.openidClientsDN;
    }

    public final String getJwtKeyStoreFile() {
        return this.jwtKeyStoreFile;
    }

    public final String getJwtKeyStorePin() {
        return this.jwtKeyStorePin;
    }

    public final String getJwtAuthKeyId() {
        return this.jwtAuthKeyId;
    }

    public final long getKeygenInterval() {
        return this.keygenInterval;
    }

    public final SignatureAlgorithm getJwtAuthSignAlgo() {
        return this.jwtAuthSignAlgo;
    }

    public String getPersistenceConfigFile() {
        return this.persistenceConfigFile;
    }

    public void setPersistenceConfigFile(String persistenceConfigFile) {
        this.persistenceConfigFile = persistenceConfigFile;
    }

    private String loadEncodeSalt(String saltFile) {
        Properties props = this.loadPropertiesFromFile(saltFile);
        return props.getProperty(encodeSaltKey);
    }

    private Properties loadPropertiesFromFile(String filename) {
        FileInputStream fileistream = null;
        try {
            fileistream = new FileInputStream(filename);
            Properties props = new Properties();
            props.load(fileistream);
            fileistream.close();
            Properties properties = props;
            return properties;
        }
        catch (IOException e) {
            throw new ServiceException("Could not load properties from file " + filename, e);
        }
        catch (IllegalArgumentException e) {
            throw new ServiceException("Could not load properties from file " + filename, e);
        }
        finally {
            if (fileistream != null) {
                try {
                    fileistream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Properties preparePersistenceProperties(PersistenceConfiguration persistenceConfiguration) {
        Properties decryptedConnectionProperties;
        FileConfiguration persistenceConfig = persistenceConfiguration.getConfiguration();
        Properties connectionProperties = persistenceConfig.getProperties();
        try {
            decryptedConnectionProperties = PropertiesDecrypter.decryptAllProperties((StringEncrypter)StringEncrypter.defaultInstance(), (Properties)connectionProperties, (String)this.salt);
        }
        catch (StringEncrypter.EncryptionException ex) {
            throw new ServiceException("Failed to decript configuration properties", ex);
        }
        return decryptedConnectionProperties;
    }

    private static enum BootstrapConfigKeys {
        ListenEnable("radius.listen.enable"),
        AuthScheme("radius.auth.scheme"),
        SaltFile("radius.config.saltfile"),
        PersistenceConfigFile("radius.persist.config"),
        PersistenceType("persistence.type"),
        JwtKeyStoreFile("radius.jwt.keyStoreFile"),
        JwtKeyStorePin("radius.jwt.keyStorePin"),
        JwtAuthKeyId("radius.jwt.auth.keyId"),
        JwtKeyGenInterval("radius.jwt.keygen.interval"),
        ConfigDN("oxradius_ConfigurationEntryDN"),
        OpenIdClientsDN("radius.openid_clients_DN"),
        ClientsDN("radius.clients_DN"),
        JwtAuthSignatureAlgorithm("radius.jwt.auth.signAlgorithm"),
        DefaultHybridStorage("storage.default");

        private String keyName;

        private BootstrapConfigKeys(String keyName) {
            this.keyName = keyName;
        }

        public String getKeyName() {
            return this.keyName;
        }
    }

    private static enum AuthScheme {
        ONE_STEP_AUTH,
        TWO_STEP_AUTH;

    }
}

