/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.radius.server.tinyradius;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.gluu.radius.exception.ServerException;
import org.gluu.radius.server.RadiusEventListener;
import org.gluu.radius.server.RadiusEventListenerManager;
import org.gluu.radius.server.RadiusServerAdapter;
import org.gluu.radius.server.tinyradius.TinyRadiusAccessRequestContext;
import org.gluu.radius.server.tinyradius.TinyRadiusAccountingRequestContext;
import org.gluu.radius.server.tinyradius.TinyRadiusSharedSecretRequestContext;
import org.gluu.radius.util.ThreadUtil;
import org.tinyradius.packet.AccessRequest;
import org.tinyradius.packet.AccountingRequest;
import org.tinyradius.packet.RadiusPacket;
import org.tinyradius.util.RadiusServer;

public class TinyRadiusServerAdapter
implements RadiusServerAdapter {
    private static final String AUTH_THREAD_NAME = "Radius Auth Listener";
    private static final String ACCT_THREAD_NAME = "Radius Acct Listener";
    private TinyRadiusServerImpl serverImpl = new TinyRadiusServerImpl();

    @Override
    public void configureServer(String listenInterface, Integer authPort, Integer acctPort) {
        try {
            this.serverImpl.setAuthPort(authPort);
            this.serverImpl.setAcctPort(acctPort);
            this.serverImpl.setListenAddress(InetAddress.getByName(listenInterface));
        }
        catch (UnknownHostException e) {
            throw new ServerException("Tinyradius server configuration failed", e);
        }
    }

    @Override
    public void registerRadiusEventListener(RadiusEventListener listener) {
        this.serverImpl.getEventListenerManager().addListener(listener);
    }

    @Override
    public void unregisterRadiusEventListener(RadiusEventListener listener) {
        this.serverImpl.getEventListenerManager().removeListener(listener);
    }

    @Override
    public void runServer() {
        this.serverImpl.start(true, true);
        long sleeptime = 1000L;
        int checkcount = 5;
        boolean stillrunning = true;
        do {
            try {
                Thread.sleep(sleeptime);
            }
            catch (InterruptedException e) {
                this.serverImpl.stop();
                throw new ServerException("Tinyradius interrupted", e);
            }
            stillrunning = this.areServerThreadsRunning();
        } while (--checkcount > 0);
        if (!stillrunning) {
            this.serverImpl.stop();
            throw new ServerException("TinyRadius server stopped unexpectedly");
        }
    }

    @Override
    public void stopServer() {
        this.serverImpl.stop();
    }

    private boolean areServerThreadsRunning() {
        Thread acct_thread = ThreadUtil.findRunningThread(ACCT_THREAD_NAME);
        Thread auth_thread = ThreadUtil.findRunningThread(AUTH_THREAD_NAME);
        return acct_thread != null && auth_thread != null;
    }

    private class TinyRadiusServerImpl
    extends RadiusServer {
        private RadiusEventListenerManager eventListenerManager = new RadiusEventListenerManager();

        public RadiusEventListenerManager getEventListenerManager() {
            return this.eventListenerManager;
        }

        public String getUserPassword(String username) {
            return null;
        }

        public String getSharedSecret(InetSocketAddress client) {
            String clientIp = client.getAddress().getHostAddress();
            TinyRadiusSharedSecretRequestContext context = new TinyRadiusSharedSecretRequestContext(clientIp);
            this.eventListenerManager.sharedSecretRequestNotification(context);
            return context.getSharedSecret();
        }

        public RadiusPacket accessRequestReceived(AccessRequest request, InetSocketAddress client) {
            RadiusPacket response = null;
            TinyRadiusAccessRequestContext context = new TinyRadiusAccessRequestContext(client, request);
            this.eventListenerManager.accessRequestNotification(context);
            response = context.isGranted() ? new RadiusPacket(2, request.getPacketIdentifier()) : new RadiusPacket(3, request.getPacketIdentifier());
            this.copyProxyState((RadiusPacket)request, response);
            return response;
        }

        public RadiusPacket accountingRequestReceived(AccountingRequest request, InetSocketAddress client) {
            RadiusPacket response = null;
            TinyRadiusAccountingRequestContext context = new TinyRadiusAccountingRequestContext(client, request);
            this.eventListenerManager.accountingRequestNotification(context);
            this.copyProxyState((RadiusPacket)request, response);
            return response;
        }
    }
}

