/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.radius.server.tinyradius;

import java.net.InetSocketAddress;
import org.gluu.radius.exception.ServerException;
import org.gluu.radius.server.AccountingRequestContext;
import org.gluu.radius.server.AccountingStatus;
import org.gluu.radius.server.tinyradius.TinyRadiusRequestContext;
import org.tinyradius.packet.AccountingRequest;
import org.tinyradius.packet.RadiusPacket;
import org.tinyradius.util.RadiusException;

public class TinyRadiusAccountingRequestContext
extends TinyRadiusRequestContext
implements AccountingRequestContext {
    public TinyRadiusAccountingRequestContext(InetSocketAddress client, AccountingRequest request) {
        super(client, (RadiusPacket)request);
    }

    @Override
    public String getUsername() {
        try {
            AccountingRequest req = (AccountingRequest)this.packet;
            return req.getUserName();
        }
        catch (RuntimeException e) {
            throw new ServerException("Error getting username from accounting request packet", e);
        }
        catch (RadiusException e) {
            throw new ServerException("Error getting username from accounting request packet", e);
        }
    }

    @Override
    public AccountingStatus getAccountingStatus() {
        try {
            AccountingRequest req = (AccountingRequest)this.packet;
            AccountingStatus status = AccountingStatus.Unknown;
            switch (req.getAcctStatusType()) {
                default: {
                    break;
                }
                case 8: {
                    status = AccountingStatus.AccountingOff;
                    break;
                }
                case 7: {
                    status = AccountingStatus.AccountingOn;
                    break;
                }
                case 3: {
                    status = AccountingStatus.InterimUpdate;
                    break;
                }
                case 1: {
                    status = AccountingStatus.Start;
                    break;
                }
                case 2: {
                    status = AccountingStatus.Stop;
                }
            }
            return status;
        }
        catch (RadiusException e) {
            throw new ServerException("Error getting accounting status", e);
        }
        catch (RuntimeException e) {
            throw new ServerException("Error getting accounting status", e);
        }
    }
}

