/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.radius.server.tinyradius;

import java.net.InetSocketAddress;
import org.gluu.radius.exception.ServerException;
import org.gluu.radius.server.AccessRequestContext;
import org.gluu.radius.server.tinyradius.TinyRadiusRequestContext;
import org.tinyradius.packet.AccessRequest;
import org.tinyradius.packet.RadiusPacket;

public class TinyRadiusAccessRequestContext
extends TinyRadiusRequestContext
implements AccessRequestContext {
    private boolean granted = false;

    public TinyRadiusAccessRequestContext(InetSocketAddress address, AccessRequest packet) {
        super(address, (RadiusPacket)packet);
    }

    @Override
    public String getUsername() {
        try {
            AccessRequest req = (AccessRequest)this.packet;
            return req.getUserName();
        }
        catch (RuntimeException e) {
            throw new ServerException("Error getting username from access request packet", e);
        }
    }

    @Override
    public String getPassword() {
        AccessRequest req = (AccessRequest)this.packet;
        return req.getUserPassword();
    }

    @Override
    public String getAuthProtocol() {
        AccessRequest req = (AccessRequest)this.packet;
        return req.getAuthProtocol();
    }

    @Override
    public AccessRequestContext setGranted(boolean granted) {
        this.granted = granted;
        return this;
    }

    public boolean isGranted() {
        return this.granted;
    }
}

