/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.radius.server.lifecycle;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.gluu.oxauth.client.JwkClient;
import org.gluu.oxauth.client.JwkResponse;
import org.gluu.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.gluu.oxauth.model.jwk.JSONWebKeySet;
import org.gluu.radius.KnownService;
import org.gluu.radius.ServiceLocator;
import org.gluu.radius.exception.ServerException;
import org.gluu.radius.model.Client;
import org.gluu.radius.server.GluuRadiusServer;
import org.gluu.radius.service.BootstrapConfigService;
import org.gluu.radius.service.CryptoService;
import org.gluu.radius.service.OpenIdConfigurationService;
import org.gluu.radius.service.ServerConfigService;
import org.json.JSONObject;

public class Runner
extends Thread {
    private static final Logger log = Logger.getLogger(Runner.class);
    private static final long sleeptimeout = 2000L;
    private static final String PRIVATE_KEY_JWT_AUTH = "private_key_jwt";
    private static final long DEFAULT_JWKS_DOWNLOAD_INTERVAL = 5L;
    private static final String HEALTH_STATUS_FILE = "/tmp/gluu-radius-health";
    private GluuRadiusServer server;
    private boolean stop;
    private long keygenLastRun;
    private long jwksDownloadLastRun;
    private JSONWebKeySet currentKeyset;
    private boolean forceJwksDownload;

    public Runner(GluuRadiusServer server) {
        this.server = server;
        this.stop = false;
        this.keygenLastRun = System.currentTimeMillis();
        this.jwksDownloadLastRun = System.currentTimeMillis();
        this.forceJwksDownload = true;
    }

    @Override
    public void run() {
        try {
            if (!this.createHealthStatusFile()) {
                log.warn((Object)"Could not create the health status check file");
            }
            while (!this.stop) {
                log.debug((Object)"Performing background operations");
                this.performBackgroundOperations();
                log.debug((Object)"Background operations complete");
                Thread.sleep(2000L);
            }
            if (this.server != null) {
                this.server.stop();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ServerException e) {
            log.error((Object)"Error while shutting down the server", (Throwable)e);
        }
    }

    public void stopRunning() {
        this.stop = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void performBackgroundOperations() {
        CryptoService cryptoService = (CryptoService)ServiceLocator.getService(KnownService.Crypto);
        try {
            cryptoService.beginWriteOpts();
            BootstrapConfigService bcService = (BootstrapConfigService)ServiceLocator.getService(KnownService.BootstrapConfig);
            long durationsincelastrun = System.currentTimeMillis() - this.keygenLastRun;
            long updateinterval = bcService.getKeygenInterval() * 86400L * 1000L;
            if (bcService.getKeygenInterval() != 0L && durationsincelastrun >= updateinterval) {
                this.currentKeyset = this.generateKeys(cryptoService);
                cryptoService.exportAuthPrivateKeyToPem();
                this.keygenLastRun = System.currentTimeMillis();
            }
            if (this.currentKeyset != null) {
                ServerConfigService scService = (ServerConfigService)ServiceLocator.getService(KnownService.ServerConfig);
                String inum = scService.getServerConfiguration().getOpenidUsername();
                SignatureAlgorithm authsignalgorithm = bcService.getJwtAuthSignAlgo();
                this.saveOpenIdClientConfig(inum, this.currentKeyset, authsignalgorithm);
                this.currentKeyset = null;
            }
            long durationsincelastdownload = System.currentTimeMillis() - this.jwksDownloadLastRun;
            long downloadinterval = 300000L;
            if (this.forceJwksDownload || durationsincelastdownload >= downloadinterval) {
                if (this.downloadJwksServerKeys()) {
                    this.jwksDownloadLastRun = System.currentTimeMillis();
                }
                this.forceJwksDownload = false;
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while performing background operations", (Throwable)e);
        }
        finally {
            cryptoService.endWriteOpts();
        }
    }

    private final JSONWebKeySet generateKeys(CryptoService cryptoService) throws Exception {
        JSONWebKeySet keyset = null;
        keyset = cryptoService.generateKeys();
        return keyset;
    }

    private final void saveOpenIdClientConfig(String inum, JSONWebKeySet keyset, SignatureAlgorithm authSignatureAlgorithm) {
        OpenIdConfigurationService openidService = (OpenIdConfigurationService)ServiceLocator.getService(KnownService.OpenIdConfig);
        Client client = openidService.loadOpenIdClient(inum);
        client.setJwks(keyset.toString());
        client.setTokenEndpointAuthMethod(PRIVATE_KEY_JWT_AUTH);
        client.setTokenEndpointAuthSigningAlg(authSignatureAlgorithm.name());
        openidService.saveOpenIdClient(client);
    }

    private final boolean downloadJwksServerKeys() {
        OpenIdConfigurationService openidService = (OpenIdConfigurationService)ServiceLocator.getService(KnownService.OpenIdConfig);
        JwkClient jwkClient = new JwkClient(openidService.getJwksUri());
        JwkResponse response = jwkClient.exec();
        if (response == null || response != null && response.getStatus() != 200) {
            log.error((Object)"JWKS download failed");
            return false;
        }
        JSONObject jwks = response.getJwks().toJSONObject();
        CryptoService cryptoService = (CryptoService)ServiceLocator.getService(KnownService.Crypto);
        cryptoService.setServerKeyset(jwks);
        return true;
    }

    private final boolean createHealthStatusFile() {
        try {
            File hsf = new File(HEALTH_STATUS_FILE);
            if (hsf.exists()) {
                hsf.delete();
            }
            return hsf.createNewFile();
        }
        catch (IOException e) {
            log.error((Object)"Error creating health status file", (Throwable)e);
            return false;
        }
    }
}

