/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.radius.server.filter;

import java.util.ArrayList;
import java.util.List;
import org.gluu.oxauth.client.supergluu.impl.ICryptoProviderFactory;
import org.gluu.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.gluu.radius.model.AuthScope;
import org.gluu.radius.model.ServerConfiguration;
import org.gluu.radius.service.BootstrapConfigService;
import org.gluu.radius.service.CryptoService;
import org.gluu.radius.service.OpenIdConfigurationService;
import org.gluu.radius.util.EncDecUtil;
import org.json.JSONObject;

public class SuperGluuAccessRequestFilterConfig {
    private static final Long DEFAULT_AUTHENTICATION_TIMEOUT = 30000L;
    private static final String SESSION_STATUS_URI = "/oxauth/restv1/session_status";
    private final BootstrapConfigService bcService;
    private final OpenIdConfigurationService openIdConfigService;
    private ServerConfiguration serverConfig;
    private List<AuthScope> scopes;
    private CryptoService cryptoService;

    public SuperGluuAccessRequestFilterConfig(BootstrapConfigService bcService, ServerConfiguration serverConfig, List<AuthScope> scopes, OpenIdConfigurationService openIdConfigService, CryptoService cryptoService) {
        this.bcService = bcService;
        this.serverConfig = serverConfig;
        this.openIdConfigService = openIdConfigService;
        this.scopes = scopes;
        this.cryptoService = cryptoService;
    }

    public String getOpenidUsername() {
        return this.serverConfig.getOpenidUsername();
    }

    public String getOpenidPassword() {
        return EncDecUtil.decode(this.serverConfig.getOpenidPassword(), this.bcService.getEncodeSalt());
    }

    public Long getAuthenticationTimeout() {
        if (this.serverConfig.getAuthenticationTimeout() == 0) {
            return DEFAULT_AUTHENTICATION_TIMEOUT;
        }
        return this.serverConfig.getAuthenticationTimeout().longValue();
    }

    public String getAcrValue() {
        return this.serverConfig.getAcrValue();
    }

    public List<String> getScopes() {
        ArrayList<String> ret = new ArrayList<String>();
        for (AuthScope scope : this.scopes) {
            if (scope.getName() != null) {
                ret.add(scope.getName());
                continue;
            }
            if (scope.getId() == null) continue;
            ret.add(scope.getId());
        }
        return ret;
    }

    public String getJwtKeyStoreFile() {
        return this.bcService.getJwtKeyStoreFile();
    }

    public String getJwtKeyStorePin() {
        return this.bcService.getJwtKeyStorePin();
    }

    public String getJwtAuthKeyId() {
        return this.cryptoService.getAuthSigningKeyId();
    }

    public SignatureAlgorithm getJwtAuthSignAlgo() {
        return this.bcService.getJwtAuthSignAlgo();
    }

    public String getTokenEndpointUrl() {
        return this.openIdConfigService.getTokenEndpoint();
    }

    public String getAuthorizationEndpointUrl() {
        return this.openIdConfigService.getAuthorizationEndpoint();
    }

    public String getRegistrationEndpointUrl() {
        return this.openIdConfigService.getRegistrationEndpoint();
    }

    public String getOpenIdBaseUrl() {
        return this.serverConfig.getOpenidBaseUrl();
    }

    public String getSessionStatusUrl() {
        return this.serverConfig.getOpenidBaseUrl() + SESSION_STATUS_URI;
    }

    public boolean isOneStepAuth() {
        return this.bcService.isOneStepAuth();
    }

    public boolean isTwoStepAuth() {
        return this.bcService.isTwoStepAuth();
    }

    public JSONObject getServerKeyset() {
        return this.cryptoService.getServerKeyset();
    }

    public ICryptoProviderFactory getCryptoProviderFactory() {
        return this.cryptoService;
    }

    public CryptoService getCryptoService() {
        return this.cryptoService;
    }
}

